/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.gsea;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import org.biopax.paxtools.io.BioPAXIOHandler;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.io.gsea.GSEAConverter;
import org.biopax.paxtools.io.gsea.GSEAEntry;
import org.biopax.paxtools.model.Model;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class GSEAConverterTest {
    static PrintStream out = null;
    static BioPAXIOHandler handler = new SimpleIOHandler();
    static final String outFile = GSEAConverterTest.class.getResource("/").getFile() + File.separator + "gseaConverterTest.out.txt";

    @BeforeClass
    public static void setupTest() throws IOException {
        out = new PrintStream(new FileOutputStream(outFile, false));
    }

    @AfterClass
    public static void endTest() throws IOException {
        out.close();
    }

    @Test
    public void testWriteL2GSEA() throws Exception {
        File testDir = new File(this.getClass().getResource("/L2").getFile());
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith("owl");
            }
        };
        out.println("testWriteL2GSEA:");
        for (String testFile : testDir.list(filter)) {
            InputStream in = this.getClass().getResourceAsStream("/L2/" + testFile);
            Model level2 = handler.convertFromOWL(in);
            GSEAConverter gseaConverter = new GSEAConverter("GENE_SYMBOL", true);
            Collection entries = gseaConverter.convert(level2);
            Assert.assertEquals((long)1L, (long)entries.size());
            GSEAEntry entry = (GSEAEntry)entries.iterator().next();
            Assert.assertEquals((Object)"mTOR signaling pathway", (Object)entry.name());
            Assert.assertTrue((boolean)entry.description().contains("nci-nature"));
            Assert.assertEquals((Object)"9606", (Object)entry.taxID());
            Assert.assertEquals((Object)"GENE_SYMBOL", (Object)entry.idType());
            Assert.assertEquals((long)27L, (long)entry.getIdentifiers().size());
            new GSEAConverter("GENE_SYMBOL", true).writeToGSEA(level2, (OutputStream)out);
            gseaConverter = new GSEAConverter("NP", true);
            entries.clear();
            entries = gseaConverter.convert(level2);
            Assert.assertEquals((long)1L, (long)entries.size());
            entry = (GSEAEntry)entries.iterator().next();
            Assert.assertEquals((Object)"mTOR signaling pathway", (Object)entry.name());
            Assert.assertTrue((boolean)entry.description().contains("nci-nature"));
            Assert.assertEquals((Object)"9606", (Object)entry.taxID());
            Assert.assertEquals((Object)"NP", (Object)entry.idType());
            Assert.assertEquals((long)25L, (long)entry.getIdentifiers().size());
            new GSEAConverter("NP", true).writeToGSEA(level2, (OutputStream)out);
            in.close();
        }
    }

    @Test
    public void testWriteL3GSEA() throws Exception {
        File testDir = new File(this.getClass().getResource("/L3").getFile());
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith("owl");
            }
        };
        out.println("testWriteL3GSEA:");
        for (String testFile : testDir.list(filter)) {
            InputStream in = this.getClass().getResourceAsStream("/L3/" + testFile);
            Model level3 = handler.convertFromOWL(in);
            GSEAConverter gseaConverter = new GSEAConverter("uniprot", true);
            Collection entries = gseaConverter.convert(level3);
            new GSEAConverter("uniprot", true).writeToGSEA(level3, (OutputStream)out);
            in.close();
        }
    }
}

