/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.gsea;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.Fetcher;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.converter.LevelUpgrader;
import org.biopax.paxtools.io.gsea.GSEAEntry;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.BioSource;
import org.biopax.paxtools.model.level3.Pathway;
import org.biopax.paxtools.model.level3.ProteinReference;
import org.biopax.paxtools.model.level3.Provenance;
import org.biopax.paxtools.model.level3.Xref;
import org.biopax.paxtools.util.Filter;

public class GSEAConverter {
    private final String database;
    private final boolean crossSpeciesCheckEnabled;

    public GSEAConverter() {
        this("", true);
    }

    public GSEAConverter(String database, boolean crossSpeciesCheckEnabled) {
        this.database = database;
        this.crossSpeciesCheckEnabled = crossSpeciesCheckEnabled;
    }

    public void writeToGSEA(Model model, OutputStream out) throws IOException {
        Collection<GSEAEntry> entries = this.convert(model);
        if (entries.size() > 0) {
            OutputStreamWriter writer = new OutputStreamWriter(out);
            for (GSEAEntry entry : entries) {
                writer.write(entry.toString() + "\n");
            }
            ((Writer)writer).flush();
        }
    }

    public Collection<GSEAEntry> convert(Model model) {
        TreeSet<GSEAEntry> toReturn = new TreeSet<GSEAEntry>(new Comparator<GSEAEntry>(){

            @Override
            public int compare(GSEAEntry o1, GSEAEntry o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        Model l3Model = null;
        l3Model = model.getLevel() == BioPAXLevel.L1 || model.getLevel() == BioPAXLevel.L2 ? new LevelUpgrader().filter(model) : model;
        Set pathways = l3Model.getObjects(Pathway.class);
        if (!pathways.isEmpty()) {
            for (Pathway pathway : pathways) {
                String name = pathway.getDisplayName();
                name = name == null ? pathway.getStandardName() : name;
                name = name == null ? pathway.getRDFId() : name;
                String dataSource = this.getDataSource(pathway.getDataSource());
                Set pathwayProteinRefs = new Fetcher((EditorMap)SimpleEditorMap.L3, new Filter[]{Fetcher.nextStepFilter}).fetch((BioPAXElement)pathway, ProteinReference.class);
                if (pathwayProteinRefs.isEmpty()) continue;
                Map<String, Set<ProteinReference>> orgToPrsMap = this.organismToProteinRefsMap(pathwayProteinRefs);
                Collection<GSEAEntry> entries = this.createGseaEntries(name, dataSource, orgToPrsMap);
                toReturn.addAll(entries);
            }
        } else {
            Map<String, Set<ProteinReference>> orgToPrsMap;
            Set allProteinRefs = l3Model.getObjects(ProteinReference.class);
            if (!allProteinRefs.isEmpty() && !(orgToPrsMap = this.organismToProteinRefsMap(allProteinRefs)).isEmpty()) {
                toReturn.addAll(this.createGseaEntries("From a BioPAX sub-model (protein references, no pathways)", this.getDataSource(l3Model.getObjects(Provenance.class)), orgToPrsMap));
            }
        }
        return toReturn;
    }

    private Collection<GSEAEntry> createGseaEntries(final String name, final String dataSource, final Map<String, Set<ProteinReference>> orgToPrsMap) {
        final List<GSEAEntry> toReturn = Collections.synchronizedList(new ArrayList());
        ExecutorService exe = Executors.newFixedThreadPool(orgToPrsMap.keySet().size());
        for (final String org : orgToPrsMap.keySet()) {
            exe.submit(new Runnable(){

                @Override
                public void run() {
                    GSEAEntry gseaEntry = new GSEAEntry(name, org, GSEAConverter.this.database, "datasource: " + dataSource);
                    GSEAConverter.this.processProteinReferences((Set)orgToPrsMap.get(org), gseaEntry);
                    toReturn.add(gseaEntry);
                }
            });
        }
        exe.shutdown();
        try {
            exe.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted unexpectedly!");
        }
        return toReturn;
    }

    private Map<String, Set<ProteinReference>> organismToProteinRefsMap(Set<ProteinReference> proteinRefs) {
        HashMap<String, Set<ProteinReference>> map = new HashMap<String, Set<ProteinReference>>();
        if (proteinRefs.isEmpty()) {
            throw new IllegalArgumentException("Empty set");
        }
        if (this.crossSpeciesCheckEnabled) {
            for (ProteinReference r : proteinRefs) {
                String key = this.getTaxID(r.getOrganism());
                HashSet<ProteinReference> prs = (HashSet<ProteinReference>)map.get(key);
                if (prs == null) {
                    prs = new HashSet<ProteinReference>();
                    map.put(key, prs);
                }
                prs.add(r);
            }
        } else {
            map.put("", proteinRefs);
        }
        return map;
    }

    void processProteinReferences(Set<ProteinReference> prs, GSEAEntry targetEntry) {
        block0: for (ProteinReference aProteinRef : prs) {
            if (this.crossSpeciesCheckEnabled && !targetEntry.taxID().equals(this.getTaxID(aProteinRef.getOrganism()))) continue;
            if (this.database != null && !this.database.isEmpty()) {
                String accession;
                String lowcaseUri = aProteinRef.getRDFId().toLowerCase();
                if (lowcaseUri.startsWith("urn:miriam:" + this.database.toLowerCase())) {
                    accession = aProteinRef.getRDFId();
                    accession = accession.substring(accession.lastIndexOf(":") + 1);
                    targetEntry.getIdentifiers().add(accession);
                    continue;
                }
                if (lowcaseUri.startsWith("http://identifiers.org/") && lowcaseUri.contains(this.database.toLowerCase())) {
                    accession = aProteinRef.getRDFId();
                    accession = accession.substring(accession.lastIndexOf("/") + 1);
                    targetEntry.getIdentifiers().add(accession);
                    continue;
                }
                TreeSet<Xref> orderedXrefs = new TreeSet<Xref>(new Comparator<Xref>(){

                    @Override
                    public int compare(Xref o1, Xref o2) {
                        return o1.toString().compareTo(o2.toString());
                    }
                });
                orderedXrefs.addAll(aProteinRef.getXref());
                for (Xref aXref : orderedXrefs) {
                    if (aXref.getId() == null || aXref.getDb() == null || !aXref.getDb().equalsIgnoreCase(this.database) && !aXref.getId().toLowerCase().startsWith(this.database.toLowerCase() + ":") && !aXref.getId().toLowerCase().startsWith(this.database.toLowerCase() + "_")) continue;
                    targetEntry.getIdentifiers().add(aXref.getId());
                    continue block0;
                }
                continue;
            }
            targetEntry.getIdentifiers().add(aProteinRef.getRDFId());
        }
    }

    private String getDataSource(Set<Provenance> provenances) {
        if (provenances.isEmpty()) {
            return "N/A";
        }
        TreeSet<String> dsNames = new TreeSet<String>();
        for (Provenance provenance : provenances) {
            String name = provenance.getDisplayName();
            if (name == null) {
                name = provenance.getStandardName();
            }
            if (name == null && !provenance.getName().isEmpty()) {
                name = (String)provenance.getName().iterator().next();
            }
            if (name == null || name.length() <= 0) continue;
            dsNames.add(name.toLowerCase());
        }
        return StringUtils.join(dsNames, (String)";");
    }

    private String getTaxID(BioSource org) {
        if (org != null) {
            for (Xref xref : org.getXref()) {
                if (!xref.getDb().equalsIgnoreCase("taxonomy")) continue;
                return xref.getId();
            }
        }
        return "";
    }
}

