/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.controller.Cloner;
import org.biopax.paxtools.controller.Completer;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.Integrator;
import org.biopax.paxtools.controller.Merger;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.converter.OneTwoThree;
import org.biopax.paxtools.io.BioPAXIOHandler;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.io.gsea.GSEAConverter;
import org.biopax.paxtools.io.sif.InteractionRule;
import org.biopax.paxtools.io.sif.SimpleInteractionConverter;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level2.entity;
import org.biopax.paxtools.model.level3.Entity;
import org.biopax.paxtools.query.QueryExecuter;
import org.biopax.paxtools.query.algorithm.Direction;
import org.biopax.validator.BiopaxValidatorClient;
import org.biopax.validator.jaxb.Behavior;
import org.mskcc.psibiopax.converter.PSIMIBioPAXConverter;

public class PaxtoolsMain {
    public static Log log = LogFactory.getLog(PaxtoolsMain.class);
    private static SimpleIOHandler io = new SimpleIOHandler();

    public static void main(String[] argv) throws IOException, InvocationTargetException, IllegalAccessException {
        io.mergeDuplicates(true);
        if (argv.length == 0) {
            PaxtoolsMain.help();
        } else {
            Command.valueOf(argv[0]).run(argv);
        }
    }

    public static void fromPsimi(String[] argv) throws IOException {
        System.out.println("PSI-MI to BioPAX Conversion Tool v2.0");
        System.out.println("Supports PSI-MI Level 2.5 (compact) model and BioPAX Level 2 or 3.");
        Integer bpLevelArg = null;
        try {
            bpLevelArg = Integer.valueOf(argv[1]);
            if (bpLevelArg != 2 && bpLevelArg != 3) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            System.err.println("Incorrect BioPAX level specified: " + argv[1] + " .  Please select level 2 or 3.");
            System.exit(0);
        }
        String inputFile = argv[2];
        String outputFile = argv[3];
        if (!new File(inputFile).exists()) {
            System.err.println("input filename: " + inputFile + " does not exist!");
            System.exit(0);
        }
        try {
            BioPAXLevel bpLevel = bpLevelArg == 2 ? BioPAXLevel.L2 : BioPAXLevel.L3;
            FileInputStream fis = new FileInputStream(inputFile);
            FileOutputStream fos = new FileOutputStream(outputFile);
            PSIMIBioPAXConverter converter = new PSIMIBioPAXConverter(bpLevel);
            converter.convert((InputStream)fis, (OutputStream)fos);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(0);
        }
    }

    public static void toGSEA(String[] argv) throws IOException {
        Model model = io.convertFromOWL((InputStream)new FileInputStream(argv[1]));
        new GSEAConverter(argv[3], new Boolean(argv[4]).booleanValue()).writeToGSEA(model, (OutputStream)new FileOutputStream(argv[2]));
    }

    public static void getNeighbors(String[] argv) throws IOException {
        String in = argv[1];
        String[] ids = argv[2].split(",");
        String out = argv[3];
        Model model = io.convertFromOWL((InputStream)new FileInputStream(in));
        HashSet<BioPAXElement> elements = new HashSet<BioPAXElement>();
        for (String id : ids) {
            BioPAXElement e = model.getByID(id.toString());
            if (e != null && (e instanceof Entity || e instanceof entity)) {
                elements.add(e);
                continue;
            }
            log.warn((Object)("Source element not found: " + id));
        }
        Set result = QueryExecuter.runNeighborhood(elements, (Model)model, (int)1, (Direction)Direction.BOTHSTREAM);
        Completer c = new Completer(io.getEditorMap());
        result = c.complete((Collection)result, model);
        Cloner cln = new Cloner(io.getEditorMap(), io.getFactory());
        model = cln.clone(model, result);
        if (model != null) {
            log.info((Object)("Elements in the result model: " + model.getObjects().size()));
            io.convertToOWL(model, (OutputStream)new FileOutputStream(out));
        } else {
            log.error((Object)"NULL model returned.");
        }
    }

    public static void fetch(String[] argv) throws IOException {
        String in = argv[1];
        String[] ids = argv[2].split(",");
        String out = argv[3];
        Model model = io.convertFromOWL((InputStream)new FileInputStream(in));
        io.setFactory(model.getLevel().getDefaultFactory());
        io.convertToOWL(model, (OutputStream)new FileOutputStream(out), ids);
    }

    public static void toLevel3(String[] argv) throws IOException {
        Model model = io.convertFromOWL((InputStream)new FileInputStream(argv[1]));
        if ((model = new OneTwoThree().filter(model)) != null) {
            io.setFactory(model.getLevel().getDefaultFactory());
            io.convertToOWL(model, (OutputStream)new FileOutputStream(argv[2]));
        }
    }

    public static void validate(String[] argv) throws IOException {
        block16: {
            String input = argv[1];
            String output = argv[2];
            BiopaxValidatorClient.RetFormat outf = BiopaxValidatorClient.RetFormat.HTML;
            boolean fix = false;
            boolean normalize = false;
            Integer maxErrs = null;
            Behavior level = null;
            for (int i = 3; i < argv.length; ++i) {
                if ("html".equalsIgnoreCase(argv[i])) {
                    outf = BiopaxValidatorClient.RetFormat.HTML;
                    continue;
                }
                if ("xml".equalsIgnoreCase(argv[i])) {
                    outf = BiopaxValidatorClient.RetFormat.XML;
                    continue;
                }
                if ("biopax".equalsIgnoreCase(argv[i])) {
                    outf = BiopaxValidatorClient.RetFormat.OWL;
                    continue;
                }
                if ("normalize".equalsIgnoreCase(argv[i])) {
                    normalize = true;
                    continue;
                }
                if ("auto-fix".equalsIgnoreCase(argv[i])) {
                    fix = true;
                    continue;
                }
                if ("only-errors".equalsIgnoreCase(argv[i])) {
                    level = Behavior.ERROR;
                    continue;
                }
                if (!argv[i].toLowerCase().startsWith("maxerrors=")) continue;
                String num = argv[i].substring(10);
                maxErrs = Integer.valueOf(num);
            }
            HashSet<File> files = new HashSet<File>();
            File fileOrDir = new File(input);
            if (!fileOrDir.canRead()) {
                System.out.println("Cannot read " + input);
                System.exit(-1);
            }
            if (fileOrDir.isDirectory()) {
                FilenameFilter filter = new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.endsWith(".owl");
                    }
                };
                for (String s : fileOrDir.list(filter)) {
                    files.add(new File(fileOrDir.getCanonicalPath() + File.separator + s));
                }
            } else {
                files.add(fileOrDir);
            }
            FileOutputStream os = new FileOutputStream(output);
            try {
                if (files.isEmpty()) break block16;
                BiopaxValidatorClient val = new BiopaxValidatorClient();
            }
            catch (Exception ex) {
                String msg = "Faild to Validate Using the Remote Service.\n Now Trying To Read Each File and Build The Model\nWatch Log Messages...\n";
                System.err.println(msg);
                ((OutputStream)os).write(msg.getBytes());
                for (File f : files) {
                    Model m = null;
                    msg = "";
                    try {
                        m = io.convertFromOWL((InputStream)new FileInputStream(f));
                        msg = "Model that contains " + m.getObjects().size() + " elements is created (check the log messages)\n";
                        ((OutputStream)os).write(msg.getBytes());
                    }
                    catch (Exception e) {
                        msg = "Error during validation" + e + "\n";
                        ((OutputStream)os).write(msg.getBytes());
                        e.printStackTrace();
                        log.error((Object)msg);
                    }
                    os.flush();
                }
            }
        }
    }

    public static void toSifnx(String[] argv) throws IOException {
        Model model = PaxtoolsMain.getModel((BioPAXIOHandler)io, argv[1]);
        SimpleInteractionConverter sic = new SimpleInteractionConverter(SimpleInteractionConverter.getRules((BioPAXLevel)model.getLevel()).toArray(new InteractionRule[0]));
        sic.writeInteractionsInSIFNX(model, (OutputStream)new FileOutputStream(argv[2]), (OutputStream)new FileOutputStream(argv[3]), Arrays.asList(argv[4].split(",")), Arrays.asList(argv[5].split(",")), false);
    }

    public static void toSif(String[] argv) throws IOException {
        Model model = PaxtoolsMain.getModel((BioPAXIOHandler)io, argv[1]);
        SimpleInteractionConverter sic = new SimpleInteractionConverter(SimpleInteractionConverter.getRules((BioPAXLevel)model.getLevel()).toArray(new InteractionRule[0]));
        sic.writeInteractionsInSIF(model, (OutputStream)new FileOutputStream(argv[2]));
    }

    public static void integrate(String[] argv) throws IOException {
        Model model1 = PaxtoolsMain.getModel((BioPAXIOHandler)io, argv[1]);
        Model model2 = PaxtoolsMain.getModel((BioPAXIOHandler)io, argv[2]);
        Integrator integrator = new Integrator((EditorMap)SimpleEditorMap.get((BioPAXLevel)model1.getLevel()), model1, new Model[]{model2});
        integrator.integrate();
        io.setFactory(model1.getLevel().getDefaultFactory());
        io.convertToOWL(model1, (OutputStream)new FileOutputStream(argv[3]));
    }

    public static void merge(String[] argv) throws IOException {
        Model model1 = PaxtoolsMain.getModel((BioPAXIOHandler)io, argv[1]);
        Model model2 = PaxtoolsMain.getModel((BioPAXIOHandler)io, argv[2]);
        Merger merger = new Merger((EditorMap)SimpleEditorMap.get((BioPAXLevel)model1.getLevel()));
        merger.merge(model1, new Model[]{model2});
        io.setFactory(model1.getLevel().getDefaultFactory());
        io.convertToOWL(model1, (OutputStream)new FileOutputStream(argv[3]));
    }

    static void help() {
        System.out.println("Available operations:");
        for (Command cmd : Command.values()) {
            System.out.println(cmd.name() + "\t" + cmd.description);
        }
    }

    private static Model getModel(BioPAXIOHandler io, String fName) throws FileNotFoundException {
        FileInputStream file = new FileInputStream(fName);
        return io.convertFromOWL((InputStream)file);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Command {
        merge("file1 file2 output\t\tmerges file2 into file1 and writes it into output", 3){

            public void run(String[] argv) throws IOException {
                PaxtoolsMain.merge(argv);
            }
        }
        ,
        toSif("file1 output\t\t\tconverts model to the simple interaction format", 2){

            public void run(String[] argv) throws IOException {
                PaxtoolsMain.toSif(argv);
            }
        }
        ,
        toSifnx("file1 outEdges outNodes node-prop1,node-prop2,.. edge-prop1,edge-prop2,...\tconverts model to the extendent simple interaction format", 4){

            public void run(String[] argv) throws IOException {
                PaxtoolsMain.toSifnx(argv);
            }
        }
        ,
        validate("path out [xml|html|biopax] [auto-fix] [normalize] [only-errors] [maxerrors=n]\t\tvalidates the BioPAX file (or all the files in the directory); writes the html report, xml report (including fixed xml-escaped biopax), or the biopax (fixed/normalized) only; see also: http://www.biopax.org/biopax-validator/ws.html", 3){

            public void run(String[] argv) throws IOException {
                PaxtoolsMain.validate(argv);
            }
        }
        ,
        integrate("file1 file2 output\t\tintegrates file2 into file1 and writes it into output (experimental)", 3){

            public void run(String[] argv) throws IOException {
                PaxtoolsMain.integrate(argv);
            }
        }
        ,
        toLevel3("file1 output\t\tconverts level 1 or 2 to the level 3 file", 2){

            public void run(String[] argv) throws IOException {
                PaxtoolsMain.toLevel3(argv);
            }
        }
        ,
        fromPsimi("level file1 output\t\tconverts PSI-MI Level 2.5 to biopax level 2 or 3 file", 3){

            public void run(String[] argv) throws IOException {
                PaxtoolsMain.fromPsimi(argv);
            }
        }
        ,
        toGSEA("file1 output database crossSpeciesCheck\t\tconverts level 1 or 2 or 3 to GSEA output.\t\tSearches database for participant id or uses biopax rdf id if database is \"NONE\".\t\tCross species check ensures participant protein is from same species as pathway (set to true or false).", 4){

            public void run(String[] argv) throws IOException {
                PaxtoolsMain.toGSEA(argv);
            }
        }
        ,
        fetch("file1 id1,id2,.. output\t\textracts a sub-model from file1 and writes BioPAX to output", 3){

            public void run(String[] argv) throws IOException {
                PaxtoolsMain.fetch(argv);
            }
        }
        ,
        getNeighbors("file1 id1,id2,.. output\t\tnearest neighborhood graph query (id1,id2 - of Entity sub-class only)", 3){

            public void run(String[] argv) throws IOException {
                PaxtoolsMain.getNeighbors(argv);
            }
        }
        ,
        help("\t\t\t\t\t\tprints this screen and exits", Integer.MAX_VALUE){

            public void run(String[] argv) throws IOException {
                PaxtoolsMain.help();
            }
        };

        String description;
        int params;

        private Command(String description, int params) {
            this.description = description;
            this.params = params;
        }

        public abstract void run(String[] var1) throws IOException;
    }
}

