/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.examples;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.io.BioPAXIOHandler;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level2.XReferrable;
import org.biopax.paxtools.model.level2.relationshipXref;
import org.biopax.paxtools.model.level2.unificationXref;
import org.biopax.paxtools.model.level2.xref;

public class GOUnificationXREFtoRelationshipXREFConverter {
    private static Log log = LogFactory.getLog(GOUnificationXREFtoRelationshipXREFConverter.class);
    static BioPAXIOHandler reader = new SimpleIOHandler();

    public static void main(String[] args) throws IllegalAccessException, InvocationTargetException {
        for (String arg : args) {
            log.info((Object)arg);
            if (!arg.toLowerCase().endsWith("owl")) continue;
            try {
                GOUnificationXREFtoRelationshipXREFConverter.processXrefs(arg);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private static void processXrefs(String arg) throws FileNotFoundException, IllegalAccessException, InvocationTargetException {
        FileInputStream in = new FileInputStream(new File(arg));
        Model level2 = reader.convertFromOWL((InputStream)in);
        Set unis = level2.getObjects(unificationXref.class);
        HashSet<unificationXref> gos = new HashSet<unificationXref>();
        for (unificationXref uni : unis) {
            log.trace((Object)uni.getDB());
            if (!uni.getDB().equalsIgnoreCase("GO")) continue;
            log.info((Object)("scheduling " + uni.getRDFId()));
            gos.add(uni);
        }
        for (unificationXref go : gos) {
            GOUnificationXREFtoRelationshipXREFConverter.convert(go, level2);
        }
        reader.convertToOWL(level2, (OutputStream)new FileOutputStream(arg.substring(0, arg.lastIndexOf(46)) + "-converted.owl"));
    }

    private static void convert(unificationXref uni, Model level2) {
        HashSet referrables = new HashSet(uni.isXREFof());
        relationshipXref relationshipXref2 = (relationshipXref)level2.addNew(relationshipXref.class, uni.getRDFId());
        relationshipXref2.setCOMMENT(uni.getCOMMENT());
        relationshipXref2.setDB(uni.getDB());
        relationshipXref2.setDB_VERSION(uni.getDB_VERSION());
        relationshipXref2.setID(uni.getID());
        relationshipXref2.setID_VERSION(uni.getID_VERSION());
        relationshipXref2.setRELATIONSHIP_TYPE("http://www.biopax.org/paxtools/convertedGOUnificationXREF");
        for (XReferrable referrable : referrables) {
            referrable.addXREF((xref)relationshipXref2);
        }
        for (XReferrable referrable : referrables) {
            referrable.removeXREF((xref)uni);
        }
        level2.remove((BioPAXElement)uni);
    }
}

