/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.examples;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.io.sif.InteractionRule;
import org.biopax.paxtools.io.sif.SimpleInteractionConverter;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;

public final class SifnxExportExample {
    public static void main(String[] args) throws IOException {
        if (args.length != 3) {
            System.out.println("Please run again providing arguments: input(BioPAX OWL file), edgeOutput, nodeOutput");
            System.exit(-1);
        }
        SimpleIOHandler biopaxReader = new SimpleIOHandler();
        Model model = biopaxReader.convertFromOWL((InputStream)new FileInputStream(args[0]));
        SimpleInteractionConverter sic = new SimpleInteractionConverter(SimpleInteractionConverter.getRules((BioPAXLevel)model.getLevel()).toArray(new InteractionRule[0]));
        SimpleEditorMap editorMap = SimpleEditorMap.get((BioPAXLevel)model.getLevel());
        FileOutputStream edgeStream = new FileOutputStream(args[1]);
        FileOutputStream nodeStream = new FileOutputStream(args[2]);
        sic.writeInteractionsInSIFNX(model, (OutputStream)edgeStream, (OutputStream)nodeStream, null, Arrays.asList("entity/NAME", "entity/XREF"), false);
    }
}

