/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.controller;

import java.util.HashSet;
import org.biopax.paxtools.command.CommandManager;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXFactory;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.MolecularInteraction;
import org.biopax.paxtools.model.level3.Protein;
import org.junit.Test;

public class CommandManagerTest {
    @Test
    public void TestCommandManager() {
        BioPAXFactory factory = BioPAXLevel.L3.getDefaultFactory();
        Model model = factory.createModel();
        CommandManager manager = new CommandManager(model);
        HashSet<Object> objects = new HashSet<Object>();
        Protein protein = (Protein)factory.create(Protein.class, "1");
        objects.add(protein);
        Protein protein2 = (Protein)factory.create(Protein.class, "2");
        objects.add(protein2);
        MolecularInteraction interaction = (MolecularInteraction)factory.create(MolecularInteraction.class, "3");
        objects.add(interaction);
        manager.addObjects(objects);
        System.out.println(model.getObjects().size());
        manager.undo();
        System.out.println(model.getObjects().size());
        manager.redo();
        PropertyEditor propertyEditor = PropertyEditor.createPropertyEditor(MolecularInteraction.class, (String)"participant");
        manager.addProperty((BioPAXElement)interaction, propertyEditor, (Object)protein);
        manager.addProperty((BioPAXElement)interaction, propertyEditor, (Object)protein2);
        System.out.println(model.getObjects().size());
        manager.undo();
        manager.undo();
        System.out.println(model.getObjects().size());
        manager.undo();
        System.out.println(model.getObjects().size());
        manager.redo();
        manager.redo();
        manager.redo();
        System.out.println(model.getObjects().size());
    }
}

