/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.controller;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;
import org.biopax.paxtools.controller.ModelUtils;
import org.biopax.paxtools.io.BioPAXIOHandler;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.io.SimpleIOHandlerTest;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXFactory;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.BioSource;
import org.biopax.paxtools.model.level3.Catalysis;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.Entity;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.Gene;
import org.biopax.paxtools.model.level3.GeneticInteraction;
import org.biopax.paxtools.model.level3.Pathway;
import org.biopax.paxtools.model.level3.PathwayStep;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Process;
import org.biopax.paxtools.model.level3.Protein;
import org.biopax.paxtools.model.level3.ProteinReference;
import org.biopax.paxtools.model.level3.Provenance;
import org.biopax.paxtools.model.level3.RelationshipTypeVocabulary;
import org.biopax.paxtools.model.level3.RelationshipXref;
import org.biopax.paxtools.model.level3.UnificationXref;
import org.biopax.paxtools.model.level3.Xref;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ModelUtilsTest {
    @Before
    public void setUp() throws Exception {
    }

    @Test
    public final void testMergeAndReplace() {
        BioPAXFactory factory = BioPAXLevel.L3.getDefaultFactory();
        Model m = factory.createModel();
        Complex c = (Complex)factory.create(Complex.class, "c1");
        Protein p1 = (Protein)factory.create(Protein.class, "p1");
        Protein p2 = (Protein)factory.create(Protein.class, "p2");
        ProteinReference pr1 = (ProteinReference)factory.create(ProteinReference.class, "pr1");
        UnificationXref x1 = (UnificationXref)factory.create(UnificationXref.class, "x1");
        c.addComponent((PhysicalEntity)p1);
        c.addComponent((PhysicalEntity)p2);
        c.setDisplayName("complex");
        p1.setEntityReference((EntityReference)pr1);
        p1.setDisplayName("p1");
        pr1.addXref((Xref)x1);
        pr1.setDisplayName("pr1");
        x1.setId("1");
        x1.setDb("geneid");
        ProteinReference pr2 = (ProteinReference)factory.create(ProteinReference.class, "pr2");
        UnificationXref x2 = (UnificationXref)factory.create(UnificationXref.class, "x2");
        p2.setEntityReference((EntityReference)pr2);
        p2.setDisplayName("p2");
        pr2.addXref((Xref)x2);
        pr2.setDisplayName("pr2");
        x2.setId("2");
        x2.setDb("geneid");
        m.add((BioPAXElement)c);
        m.add((BioPAXElement)p1);
        m.add((BioPAXElement)p2);
        Assert.assertEquals((long)3L, (long)m.getObjects().size());
        Assert.assertEquals((long)2L, (long)c.getComponent().size());
        System.out.println("(before) components: " + c.getComponent().toString());
        m.repair();
        Assert.assertEquals((long)7L, (long)m.getObjects().size());
        Assert.assertTrue((boolean)m.contains((BioPAXElement)x1));
        Assert.assertTrue((boolean)m.contains((BioPAXElement)x2));
        Protein p3 = (Protein)factory.create(Protein.class, "p3");
        ProteinReference pr3 = (ProteinReference)factory.create(ProteinReference.class, "pr3");
        pr3.addXref((Xref)x2);
        pr3.setDisplayName("pr3");
        p3.setEntityReference((EntityReference)pr3);
        m.replace((BioPAXElement)p2, (BioPAXElement)p3);
        System.out.println("(after) components: " + c.getComponent().toString());
        Assert.assertEquals((long)7L, (long)m.getObjects().size());
        Assert.assertEquals((long)2L, (long)c.getComponent().size());
        Assert.assertTrue((boolean)m.contains((BioPAXElement)p3));
        Assert.assertFalse((boolean)m.contains((BioPAXElement)p2));
        Assert.assertTrue((boolean)m.contains((BioPAXElement)pr1));
        Assert.assertTrue((boolean)m.contains((BioPAXElement)pr2));
        Assert.assertTrue((boolean)m.contains((BioPAXElement)x1));
        Assert.assertTrue((boolean)m.contains((BioPAXElement)x2));
        Assert.assertFalse((boolean)m.contains((BioPAXElement)pr3));
        m.repair();
        Assert.assertEquals((long)8L, (long)m.getObjects().size());
        Assert.assertTrue((boolean)m.contains((BioPAXElement)pr3));
        Assert.assertTrue((boolean)m.contains((BioPAXElement)pr2));
        Assert.assertTrue((boolean)m.contains((BioPAXElement)x2));
        Assert.assertTrue((boolean)m.contains((BioPAXElement)pr1));
        Assert.assertTrue((boolean)m.contains((BioPAXElement)x1));
        ModelUtils mu = new ModelUtils(m);
        mu.removeDependentsIfDangling((BioPAXElement)p2);
        Assert.assertEquals((long)7L, (long)m.getObjects().size());
        Assert.assertFalse((boolean)m.contains((BioPAXElement)pr2));
        m.replace((BioPAXElement)p3, null);
        Assert.assertEquals((long)1L, (long)c.getComponent().size());
        mu.removeDependentsIfDangling((BioPAXElement)p3);
        Assert.assertFalse((boolean)m.contains((BioPAXElement)pr3));
        Assert.assertFalse((boolean)m.contains((BioPAXElement)x2));
        m.replace((BioPAXElement)pr1, (BioPAXElement)x1);
        Assert.assertTrue((boolean)m.contains((BioPAXElement)pr1));
        Assert.assertEquals((Object)pr1, (Object)p1.getEntityReference());
    }

    @Test
    public final void testInferPropertyFromParent() {
        Model model = BioPAXLevel.L3.getDefaultFactory().createModel();
        Provenance pro1 = (Provenance)model.addNew(Provenance.class, "urn:miriam:pid.pathway");
        Provenance pro2 = (Provenance)model.addNew(Provenance.class, "urn:miriam:signaling-gateway");
        Pathway pw1 = (Pathway)model.addNew(Pathway.class, "pathway");
        pw1.addDataSource(pro1);
        pw1.setStandardName("Pathway");
        Pathway pw2 = (Pathway)model.addNew(Pathway.class, "sub_pathway");
        pw2.setStandardName("Sub-Pathway");
        pw2.addDataSource(pro2);
        pw1.addPathwayComponent((Process)pw2);
        Protein p1 = (Protein)model.addNew(Protein.class, "p1");
        Conversion conv1 = (Conversion)model.addNew(Conversion.class, "conv1");
        pw1.addPathwayComponent((Process)conv1);
        pw2.addPathwayComponent((Process)conv1);
        conv1.addLeft((PhysicalEntity)p1);
        ModelUtils mu = new ModelUtils(model);
        mu.inferPropertyFromParent("dataSource", new Class[]{Pathway.class});
        Assert.assertEquals((long)2L, (long)pw2.getDataSource().size());
        Assert.assertEquals((long)1L, (long)pw1.getDataSource().size());
        Assert.assertEquals((long)0L, (long)p1.getDataSource().size());
        mu.inferPropertyFromParent("dataSource", new Class[0]);
        Assert.assertEquals((long)2L, (long)pw2.getDataSource().size());
        Assert.assertEquals((long)1L, (long)pw1.getDataSource().size());
        Assert.assertEquals((long)2L, (long)p1.getDataSource().size());
    }

    @Test
    public final void testInferPropertyFromParent2() {
        Model model = BioPAXLevel.L3.getDefaultFactory().createModel();
        Pathway pw1 = (Pathway)model.addNew(Pathway.class, "pathway1");
        BioSource mm = (BioSource)model.addNew(BioSource.class, "mouse");
        pw1.setOrganism(mm);
        Protein p1 = (Protein)model.addNew(Protein.class, "p1");
        ProteinReference pr1 = (ProteinReference)model.addNew(ProteinReference.class, "pr1");
        p1.setEntityReference((EntityReference)pr1);
        Protein p2 = (Protein)model.addNew(Protein.class, "p2");
        ProteinReference pr2 = (ProteinReference)model.addNew(ProteinReference.class, "pr2");
        p2.setEntityReference((EntityReference)pr2);
        BioSource hs = (BioSource)model.addNew(BioSource.class, "human");
        pr2.setOrganism(hs);
        Conversion conv1 = (Conversion)model.addNew(Conversion.class, "conv1");
        conv1.addLeft((PhysicalEntity)p1);
        pw1.addPathwayComponent((Process)conv1);
        pw1.setStandardName("Pathway1");
        Gene g1 = (Gene)model.addNew(Gene.class, "gene1");
        PathwayStep s1 = (PathwayStep)model.addNew(PathwayStep.class, "step1");
        Catalysis ca1 = (Catalysis)model.addNew(Catalysis.class, "catalysis1");
        ca1.addControlled((Process)conv1);
        GeneticInteraction gi1 = (GeneticInteraction)model.addNew(GeneticInteraction.class, "gi1");
        pw1.addPathwayComponent((Process)gi1);
        pw1.addPathwayComponent((Process)ca1);
        pw1.addPathwayOrder(s1);
        gi1.addParticipant((Entity)g1);
        s1.addStepProcess((Process)ca1);
        s1.addStepProcess((Process)gi1);
        ModelUtils mu = new ModelUtils(model);
        mu.inferPropertyFromParent("organism", new Class[]{Gene.class, Pathway.class});
        Assert.assertEquals((Object)hs, (Object)pr2.getOrganism());
        Assert.assertEquals((Object)mm, (Object)g1.getOrganism());
        Assert.assertEquals((long)1L, (long)g1.getComment().size());
        Assert.assertNull((Object)pr1.getOrganism());
        mu.generateEntityOrganismXrefs();
    }

    @Test
    public final void testA() {
        Model model = BioPAXLevel.L3.getDefaultFactory().createModel();
        Provenance pro1 = (Provenance)model.addNew(Provenance.class, "urn:miriam:pid.pathway");
        Protein p1 = (Protein)model.addNew(Protein.class, "p1");
        Pathway pw1 = (Pathway)model.addNew(Pathway.class, "pathway");
        Pathway pw2 = (Pathway)model.addNew(Pathway.class, "sub_pathway");
        Conversion conv1 = (Conversion)model.addNew(Conversion.class, "conv1");
        GeneticInteraction gi1 = (GeneticInteraction)model.addNew(GeneticInteraction.class, "gi1");
        Gene g1 = (Gene)model.addNew(Gene.class, "gene1");
        pw1.addDataSource(pro1);
        pw1.setStandardName("Pathway");
        pw1.addPathwayComponent((Process)pw2);
        pw1.addPathwayComponent((Process)conv1);
        conv1.addLeft((PhysicalEntity)p1);
        pw2.setStandardName("Sub-Pathway");
        pw2.addDataSource(pro1);
        pw2.addPathwayComponent((Process)gi1);
        gi1.addParticipant((Entity)g1);
        ModelUtils mu = new ModelUtils(model);
        mu.generateEntityProcessXrefs(Process.class);
        Assert.assertEquals((long)4L, (long)model.getObjects(RelationshipXref.class).size());
        Assert.assertEquals((long)1L, (long)model.getObjects(RelationshipTypeVocabulary.class).size());
        for (Entity e : model.getObjects(Entity.class)) {
            if (e.equals(pw1)) continue;
            Assert.assertFalse((boolean)e.getXref().isEmpty());
        }
    }

    private void printModel(Model model) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        new SimpleIOHandler().convertToOWL(model, (OutputStream)bytes);
        System.out.println(bytes.toString());
    }

    @Test
    public final void testMetrics() {
        Model model = SimpleIOHandlerTest.getL3Model((BioPAXIOHandler)new SimpleIOHandler());
        ModelUtils mu = new ModelUtils(model);
        Map metrics = mu.generateClassMetrics();
        System.out.println("metrics = " + metrics);
    }
}

