/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.controller;

import java.util.Set;
import org.biopax.paxtools.controller.PathAccessor;
import org.biopax.paxtools.impl.level3.MockFactory;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Protein;
import org.biopax.paxtools.model.level3.ProteinReference;
import org.biopax.paxtools.model.level3.PublicationXref;
import org.biopax.paxtools.model.level3.RelationshipXref;
import org.biopax.paxtools.model.level3.Xref;
import org.biopax.paxtools.util.ClassFilterSet;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class PathAccessorTest {
    @Test
    public void testPaths() {
        Model model = new MockFactory(BioPAXLevel.L3).createModel();
        Protein p1 = (Protein)model.addNew(Protein.class, "P1");
        PublicationXref px = (PublicationXref)model.addNew(PublicationXref.class, "Px1");
        px.setId("myId");
        RelationshipXref rx = (RelationshipXref)model.addNew(RelationshipXref.class, "rx1");
        rx.setId("yourID");
        ProteinReference r1 = (ProteinReference)model.addNew(ProteinReference.class, "R1");
        r1.addXref((Xref)px);
        r1.addXref((Xref)rx);
        p1.setEntityReference((EntityReference)r1);
        Protein p2 = (Protein)model.addNew(Protein.class, "P2");
        PublicationXref px2 = (PublicationXref)model.addNew(PublicationXref.class, "Px2");
        px2.setId("hisId");
        RelationshipXref rx2 = (RelationshipXref)model.addNew(RelationshipXref.class, "rx2");
        rx2.setId("herID");
        ProteinReference r2 = (ProteinReference)model.addNew(ProteinReference.class, "R2");
        p2.setEntityReference((EntityReference)r2);
        r2.addXref((Xref)px2);
        r2.addXref((Xref)rx2);
        Complex outer = (Complex)model.addNew(Complex.class, "outer");
        Complex inner = (Complex)model.addNew(Complex.class, "inner");
        Complex innermost = (Complex)model.addNew(Complex.class, "innermost");
        Protein base = (Protein)model.addNew(Protein.class, "base");
        outer.addComponent((PhysicalEntity)inner);
        inner.addComponent((PhysicalEntity)innermost);
        innermost.addComponent((PhysicalEntity)base);
        PathAccessor accessor = new PathAccessor("Protein/entityReference/xref:PublicationXref", BioPAXLevel.L3);
        Set values = accessor.getValueFromBean((BioPAXElement)p1);
        Assert.assertEquals((long)new ClassFilterSet(r1.getXref(), PublicationXref.class).size(), (long)values.size());
        accessor = new PathAccessor("Protein/entityReference/xref:RelationshipXref", BioPAXLevel.L3);
        values = accessor.getValueFromBean((BioPAXElement)p1);
        Assert.assertEquals((long)new ClassFilterSet(r1.getXref(), RelationshipXref.class).size(), (long)values.size());
        accessor = new PathAccessor("Protein/entityReference/xref:RelationshipXref/id", BioPAXLevel.L3);
        values = accessor.getValueFromBean((BioPAXElement)p1);
        Assert.assertTrue((boolean)values.contains("yourID"));
        accessor = new PathAccessor("PublicationXref/xrefOf", BioPAXLevel.L3);
        values = accessor.getValueFromBean((BioPAXElement)px2);
        Assert.assertTrue((boolean)values.contains(r2));
        accessor = new PathAccessor("Complex/component*/name", BioPAXLevel.L3);
        values = accessor.getValueFromBean((BioPAXElement)outer);
        Assert.assertThat((Object)true, (Matcher)Is.is((Object)(values.size() == 18 ? 1 : 0)));
        Assert.assertThat((Object)true, (Matcher)Is.is((Object)values.containsAll(base.getName())));
        Assert.assertThat((Object)true, (Matcher)Is.is((Object)values.containsAll(inner.getName())));
        Assert.assertThat((Object)true, (Matcher)Is.is((Object)values.containsAll(innermost.getName())));
    }
}

