/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.controller;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.PropertyReasoner;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.BioSource;
import org.biopax.paxtools.model.level3.Catalysis;
import org.biopax.paxtools.model.level3.Controller;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.Entity;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.Gene;
import org.biopax.paxtools.model.level3.GeneticInteraction;
import org.biopax.paxtools.model.level3.Pathway;
import org.biopax.paxtools.model.level3.PathwayStep;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Process;
import org.biopax.paxtools.model.level3.Protein;
import org.biopax.paxtools.model.level3.ProteinReference;
import org.biopax.paxtools.model.level3.Provenance;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PropertyReasonerTest {
    Model model;
    Provenance pro1;
    Provenance pro2;
    Pathway pw1;
    Pathway pw2;
    Protein p1;
    Protein p2;
    Conversion conv1;
    BioSource mm;
    BioSource hs;
    ProteinReference pr1;
    ProteinReference pr2;
    Gene g1;
    PathwayStep s1;
    Catalysis ca1;
    GeneticInteraction gi1;

    @Before
    public void setUp() throws Exception {
        this.model = BioPAXLevel.L3.getDefaultFactory().createModel();
        this.pro1 = (Provenance)this.model.addNew(Provenance.class, "urn:miriam:pid.pathway");
        this.pro2 = (Provenance)this.model.addNew(Provenance.class, "urn:miriam:signaling-gateway");
        this.pw1 = (Pathway)this.model.addNew(Pathway.class, "pathway");
        this.pw2 = (Pathway)this.model.addNew(Pathway.class, "sub_pathway");
        this.p1 = (Protein)this.model.addNew(Protein.class, "p1");
        this.conv1 = (Conversion)this.model.addNew(Conversion.class, "conv1");
        this.mm = (BioSource)this.model.addNew(BioSource.class, "mouse");
        this.pr1 = (ProteinReference)this.model.addNew(ProteinReference.class, "pr1");
        this.p2 = (Protein)this.model.addNew(Protein.class, "p2");
        this.pr2 = (ProteinReference)this.model.addNew(ProteinReference.class, "pr2");
        this.hs = (BioSource)this.model.addNew(BioSource.class, "human");
        this.g1 = (Gene)this.model.addNew(Gene.class, "gene1");
        this.s1 = (PathwayStep)this.model.addNew(PathwayStep.class, "step1");
        this.ca1 = (Catalysis)this.model.addNew(Catalysis.class, "catalysis1");
        this.gi1 = (GeneticInteraction)this.model.addNew(GeneticInteraction.class, "gi1");
        this.pw1.addDataSource(this.pro1);
        this.pw1.setStandardName("Pathway");
        this.pw2.setStandardName("Sub-Pathway");
        this.pw2.addDataSource(this.pro2);
        this.pw1.addPathwayComponent((Process)this.pw2);
        this.pw1.addPathwayComponent((Process)this.conv1);
        this.conv1.addLeft((PhysicalEntity)this.p1);
        this.pw1.setOrganism(this.mm);
        this.p1.setEntityReference((EntityReference)this.pr1);
        this.p2.setEntityReference((EntityReference)this.pr2);
        this.pr2.setOrganism(this.hs);
        this.pw1.addPathwayComponent((Process)this.conv1);
        this.pw1.setStandardName("Pathway1");
        this.ca1.addControlled((Process)this.conv1);
        this.ca1.addController((Controller)this.p2);
        this.pw1.addPathwayComponent((Process)this.gi1);
        this.pw1.addPathwayComponent((Process)this.ca1);
        this.gi1.addParticipant((Entity)this.g1);
        this.pw1.addPathwayOrder(this.s1);
        this.s1.addStepProcess((Process)this.ca1);
        this.s1.addStepProcess((Process)this.gi1);
    }

    @Test
    public final void testRun_Domains() {
        PropertyReasoner prr = new PropertyReasoner("organism", (EditorMap)SimpleEditorMap.L3);
        prr.setDomains(new Class[]{Gene.class, Pathway.class});
        prr.inferPropertyValue((BioPAXElement)this.pw1);
        Assert.assertEquals((Object)this.hs, (Object)this.pr2.getOrganism());
        Assert.assertEquals((long)0L, (long)this.pr2.getComment().size());
        Assert.assertEquals((Object)this.mm, (Object)this.g1.getOrganism());
        Assert.assertEquals((long)1L, (long)this.g1.getComment().size());
        Assert.assertNull((Object)this.pr1.getOrganism());
        Assert.assertEquals((long)0L, (long)this.pr1.getComment().size());
    }

    @Test
    public final void testRun_Basic() {
        PropertyReasoner prr = new PropertyReasoner("organism", (EditorMap)SimpleEditorMap.L3);
        prr.inferPropertyValue((BioPAXElement)this.pw1);
        Assert.assertEquals((Object)this.hs, (Object)this.pr2.getOrganism());
        Assert.assertEquals((long)0L, (long)this.pr2.getComment().size());
        Assert.assertEquals((Object)this.mm, (Object)this.pr1.getOrganism());
        Assert.assertEquals((Object)this.mm, (Object)this.g1.getOrganism());
        Assert.assertEquals((long)1L, (long)this.g1.getComment().size());
        prr.setPropertyName("ph");
        prr.setPropertyName("dataSource");
        Assert.assertTrue((boolean)this.p1.getDataSource().isEmpty());
        Assert.assertEquals((long)1L, (long)this.pw1.getDataSource().size());
        prr.inferPropertyValue((BioPAXElement)this.pw1);
        Assert.assertEquals((long)1L, (long)this.p1.getDataSource().size());
        Assert.assertEquals((long)2L, (long)this.pw2.getDataSource().size());
        prr.setPropertyName("name");
    }

    @Test
    public final void testRun_Clear() {
        PropertyReasoner prr = new PropertyReasoner(null, (EditorMap)SimpleEditorMap.L3);
        prr.setPropertyName("organism");
        prr.clearProperty((BioPAXElement)this.pw1);
        Assert.assertNull((Object)this.pr2.getOrganism());
        Assert.assertEquals((long)2L, (long)this.pr2.getComment().size());
        Assert.assertNull((Object)this.pr1.getOrganism());
        Assert.assertEquals((long)1L, (long)this.pr1.getComment().size());
        Assert.assertNull((Object)this.g1.getOrganism());
        Assert.assertEquals((long)1L, (long)this.g1.getComment().size());
    }

    @Test
    public final void testRun_AutoOverride() {
        PropertyReasoner prr = new PropertyReasoner(null, (EditorMap)SimpleEditorMap.L3);
        prr.setPropertyName("organism");
        Assert.assertNull((Object)this.pr1.getOrganism());
        Assert.assertEquals((Object)this.mm, (Object)this.pw1.getOrganism());
        prr.setGenerateComments(false);
        prr.inferPropertyValue((BioPAXElement)this.pw1, (Object)this.hs);
        Assert.assertEquals((Object)this.mm, (Object)this.pr1.getOrganism());
        Assert.assertEquals((long)0L, (long)this.pr1.getComment().size());
        Assert.assertEquals((Object)this.mm, (Object)this.pw2.getOrganism());
        Assert.assertEquals((long)0L, (long)this.pw2.getComment().size());
        Assert.assertEquals((Object)this.hs, (Object)this.pr2.getOrganism());
        prr.clearProperty((BioPAXElement)this.pw1);
        this.pr2.setOrganism(this.mm);
        prr.inferPropertyValue((BioPAXElement)this.pw1, (Object)this.hs);
        Assert.assertEquals((Object)this.hs, (Object)this.pw1.getOrganism());
        Assert.assertEquals((Object)this.hs, (Object)this.pr1.getOrganism());
        Assert.assertEquals((Object)this.hs, (Object)this.pw2.getOrganism());
        Assert.assertEquals((Object)this.mm, (Object)this.pr2.getOrganism());
    }

    @Test
    public final void testRun_AutoOverride1() {
        PropertyReasoner prr = new PropertyReasoner(null, (EditorMap)SimpleEditorMap.L3);
        prr.setPropertyName("organism");
        Assert.assertNull((Object)this.pr1.getOrganism());
        prr.inferPropertyValue((BioPAXElement)this.conv1, (Object)this.hs);
        Assert.assertEquals((Object)this.hs, (Object)this.pr1.getOrganism());
        Assert.assertEquals((long)1L, (long)this.pr1.getComment().size());
    }

    @Test
    public final void testRun_AutoOverride2() {
        PropertyReasoner prr = new PropertyReasoner(null, (EditorMap)SimpleEditorMap.L3);
        prr.setPropertyName("organism");
        Assert.assertNull((Object)this.pr1.getOrganism());
        prr.inferPropertyValue((BioPAXElement)this.conv1, null);
        Assert.assertNull((Object)this.pr1.getOrganism());
    }

    @Test
    public final void testRun_DefaultOverride() {
        PropertyReasoner prr = new PropertyReasoner(null, (EditorMap)SimpleEditorMap.L3);
        prr.setPropertyName("organism");
        Assert.assertEquals((Object)this.hs, (Object)this.pr2.getOrganism());
        Assert.assertNull((Object)this.pr1.getOrganism());
        Assert.assertNull((Object)this.g1.getOrganism());
        prr.resetPropertyValue((BioPAXElement)this.pw1, (Object)this.mm);
        Assert.assertEquals((long)0L, (long)this.pw1.getComment().size());
        Assert.assertEquals((Object)this.mm, (Object)this.pw2.getOrganism());
        Assert.assertEquals((long)1L, (long)this.pw2.getComment().size());
        Assert.assertEquals((Object)this.mm, (Object)this.pr2.getOrganism());
        Assert.assertEquals((long)2L, (long)this.pr2.getComment().size());
        Assert.assertEquals((Object)this.mm, (Object)this.pr1.getOrganism());
        Assert.assertEquals((long)1L, (long)this.pr1.getComment().size());
        Assert.assertEquals((Object)this.mm, (Object)this.g1.getOrganism());
        Assert.assertEquals((long)1L, (long)this.g1.getComment().size());
    }

    @Test
    public final void testRun_NullOverride() {
        PropertyReasoner prr = new PropertyReasoner(null, (EditorMap)SimpleEditorMap.L3);
        prr.setPropertyName("organism");
        try {
            prr.resetPropertyValue((BioPAXElement)this.pw1, null);
            Assert.fail((String)"Must fail!");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void printModel() {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        new SimpleIOHandler().convertToOWL(this.model, (OutputStream)bytes);
        System.out.println(bytes.toString());
    }
}

