/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.controller;

import org.biopax.paxtools.controller.ShallowCopy;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXFactory;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.Protein;
import org.biopax.paxtools.model.level3.ProteinReference;
import org.biopax.paxtools.model.level3.UnificationXref;
import org.biopax.paxtools.model.level3.Xref;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ShallowCopyTest {
    @Before
    public void setUp() throws Exception {
    }

    @Test
    public final void testCopyTString() {
        BioPAXFactory factory = BioPAXLevel.L3.getDefaultFactory();
        Protein p1 = (Protein)factory.create(Protein.class, "p1");
        ProteinReference pr1 = (ProteinReference)factory.create(ProteinReference.class, "pr1");
        UnificationXref x1 = (UnificationXref)factory.create(UnificationXref.class, "x1");
        UnificationXref x2 = (UnificationXref)factory.create(UnificationXref.class, "x2");
        p1.setEntityReference((EntityReference)pr1);
        p1.setDisplayName("p1");
        pr1.addXref((Xref)x1);
        pr1.addXref((Xref)x2);
        pr1.setDisplayName("pr1");
        x1.setId("1");
        x1.setDb("geneid");
        x2.setId("2");
        x2.setDb("geneid");
        Assert.assertEquals((Object)pr1, (Object)p1.getEntityReference());
        Assert.assertEquals((long)2L, (long)p1.getEntityReference().getXref().size());
        Protein p2 = (Protein)new ShallowCopy().copy((BioPAXElement)p1, "p1");
        Assert.assertEquals((Object)p1.getRDFId(), (Object)p2.getRDFId());
        Assert.assertFalse((p1 == p2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)p1.isEquivalent((BioPAXElement)p2));
        Assert.assertEquals((Object)pr1, (Object)p2.getEntityReference());
        Assert.assertEquals((long)2L, (long)p2.getEntityReference().getXref().size());
    }
}

