/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.controller;

import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXFactory;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.level3.BioSource;
import org.biopax.paxtools.model.level3.DeltaG;
import org.biopax.paxtools.model.level3.ProteinReference;
import org.junit.Assert;
import org.junit.Test;

public class SimpleEditorMapTest {
    @Test
    public void testSimpleEditorMap() throws Exception {
        for (BioPAXLevel level : BioPAXLevel.values()) {
            SimpleEditorMap simpleEditorMap = SimpleEditorMap.valueOf((String)level.name());
            Assert.assertNotNull((Object)simpleEditorMap);
            Assert.assertEquals((Object)level, (Object)simpleEditorMap.getLevel());
            System.out.println("initialized for " + level);
            System.out.println(simpleEditorMap);
        }
    }

    @Test
    public void testClearSingularProperty() {
        BioPAXFactory fac = BioPAXLevel.L3.getDefaultFactory();
        SimpleEditorMap em = SimpleEditorMap.L3;
        ProteinReference pr = (ProteinReference)fac.create(ProteinReference.class, "PR");
        BioSource bs = (BioSource)fac.create(BioSource.class, "BS");
        PropertyEditor editor = em.getEditorForProperty("organism", ProteinReference.class);
        pr.setOrganism(bs);
        pr.setOrganism(null);
        Assert.assertNull((Object)pr.getOrganism());
        pr.setOrganism(bs);
        editor.removeValueFromBean((Object)bs, (BioPAXElement)pr);
        Assert.assertNull((Object)pr.getOrganism());
        editor.setValueToBean(null, (BioPAXElement)pr);
        Assert.assertNull((Object)pr.getOrganism());
        Assert.assertTrue((boolean)editor.isUnknown((Object)pr.getOrganism()));
        editor = em.getEditorForProperty("ph", DeltaG.class);
        DeltaG dg = (DeltaG)fac.create(DeltaG.class, "DG");
        Assert.assertNotNull((Object)Float.valueOf(dg.getPh()));
        Assert.assertTrue((boolean)editor.isUnknown((Object)Float.valueOf(dg.getPh())));
        dg.setPh(6.5f);
        Assert.assertFalse((boolean)editor.isUnknown((Object)Float.valueOf(dg.getPh())));
        editor.setValueToBean(null, (BioPAXElement)dg);
        Assert.assertTrue((boolean)editor.isUnknown((Object)Float.valueOf(dg.getPh())));
        editor.setValueToBean((Object)BioPAXElement.UNKNOWN_FLOAT, (BioPAXElement)dg);
        Assert.assertTrue((boolean)editor.isUnknown((Object)Float.valueOf(dg.getPh())));
    }

    @Test
    public final void testComments() {
        BioPAXFactory fac = BioPAXLevel.L3.getDefaultFactory();
        SimpleEditorMap em = SimpleEditorMap.L3;
        ProteinReference pr1 = (ProteinReference)fac.create(ProteinReference.class, "pr1");
        pr1.addComment("one");
        pr1.addComment("two");
        Assert.assertEquals((long)2L, (long)pr1.getComment().size());
        pr1.getComment().clear();
        Assert.assertEquals((long)0L, (long)pr1.getComment().size());
        PropertyEditor commEditor = em.getEditorForProperty("comment", pr1.getModelInterface());
        Assert.assertNotNull((Object)commEditor);
        Assert.assertTrue((boolean)commEditor.isMultipleCardinality());
        commEditor.setValueToBean((Object)"one", (BioPAXElement)pr1);
        commEditor.setValueToBean((Object)"two", (BioPAXElement)pr1);
        Assert.assertEquals((long)2L, (long)pr1.getComment().size());
    }

    @Test
    public final void testReflection() {
        BioPAXFactory fac = BioPAXLevel.L3.getDefaultFactory();
        SimpleEditorMap em = SimpleEditorMap.L3;
        System.out.println("debug point");
    }
}

