/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.controller;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.controller.SimpleMerger;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.model.BioPAXFactory;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.BioSource;
import org.biopax.paxtools.model.level3.ProteinReference;
import org.biopax.paxtools.model.level3.PublicationXref;
import org.biopax.paxtools.model.level3.RelationshipXref;
import org.biopax.paxtools.model.level3.UnificationXref;
import org.biopax.paxtools.model.level3.Xref;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SimpleMergerTest {
    @Before
    public void setUp() throws Exception {
    }

    @Test
    public final void testMergeModel() {
        BioPAXFactory factory = BioPAXLevel.L3.getDefaultFactory();
        Model model = factory.createModel();
        Xref ref = (Xref)model.addNew(UnificationXref.class, "Xref1");
        ref.setDb("uniprotkb");
        ref.setId("Q0VCL1");
        Xref uniprotX = ref;
        ProteinReference pr = (ProteinReference)model.addNew(ProteinReference.class, "ProteinReference");
        pr.setDisplayName("ProteinReference");
        pr.addXref(uniprotX);
        ref = (Xref)model.addNew(RelationshipXref.class, "Xref2");
        ref.setDb("refseq");
        ref.setId("NP_001734");
        pr.addXref(ref);
        ref = (Xref)model.addNew(PublicationXref.class, "Xref3");
        ref.setDb("pubmed");
        ref.setId("2549346");
        pr.addXref(ref);
        ref = (Xref)model.addNew(RelationshipXref.class, "Xref4");
        ref.setDb("pubmed");
        ref.setId("2549346");
        pr.addXref(ref);
        BioSource bs = (BioSource)factory.create(BioSource.class, "Mouse");
        ref = (Xref)factory.create(UnificationXref.class, "Xref5");
        ref.setDb("taxonomy");
        ref.setId("10090");
        bs.addXref(ref);
        pr.setOrganism(bs);
        Assert.assertEquals((long)5L, (long)model.getObjects().size());
        SimpleMerger merger = new SimpleMerger((EditorMap)SimpleEditorMap.L3);
        merger.merge(model, new Model[]{model});
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            new SimpleIOHandler(BioPAXLevel.L3).convertToOWL(model, (OutputStream)out);
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
        bs = (BioSource)model.getByID("Mouse");
        Assert.assertEquals((long)1L, (long)bs.getXref().size());
        pr = (ProteinReference)model.getByID("ProteinReference");
        Assert.assertEquals((long)4L, (long)pr.getXref().size());
        Assert.assertEquals((long)7L, (long)model.getObjects().size());
    }
}

