/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.controller;

import java.util.Set;
import org.biopax.paxtools.controller.ObjectPropertyEditor;
import org.biopax.paxtools.controller.PropertyAccessor;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.controller.TransitivePropertyAccessor;
import org.biopax.paxtools.impl.level3.MockFactory;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Protein;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class TransitiveAccessorTest {
    @Test
    public void testTransitiveGet() {
        Model model = new MockFactory(BioPAXLevel.L3).createModel();
        Complex outer = (Complex)model.addNew(Complex.class, "outer");
        Complex inner = (Complex)model.addNew(Complex.class, "inner");
        Complex innermost = (Complex)model.addNew(Complex.class, "innermost");
        Protein base = (Protein)model.addNew(Protein.class, "base");
        outer.addComponent((PhysicalEntity)inner);
        inner.addComponent((PhysicalEntity)innermost);
        innermost.addComponent((PhysicalEntity)base);
        ObjectPropertyEditor pe = (ObjectPropertyEditor)SimpleEditorMap.get((BioPAXLevel)BioPAXLevel.L3).getEditorForProperty("component", Complex.class);
        TransitivePropertyAccessor ta = TransitivePropertyAccessor.create((PropertyAccessor)pe);
        Set components = ta.getValueFromBean((BioPAXElement)outer);
        Assert.assertThat((Object)true, (Matcher)Is.is((Object)(components.size() == 3 ? 1 : 0)));
        Assert.assertThat((Object)true, (Matcher)Is.is((Object)components.contains(base)));
        Assert.assertThat((Object)true, (Matcher)Is.is((Object)components.contains(inner)));
        Assert.assertThat((Object)true, (Matcher)Is.is((Object)components.contains(innermost)));
    }
}

