/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.controller;

import java.util.Arrays;
import java.util.Set;
import org.biopax.paxtools.controller.PathAccessor;
import org.biopax.paxtools.impl.level3.MockFactory;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.BioSource;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.Dna;
import org.biopax.paxtools.model.level3.DnaReference;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Protein;
import org.biopax.paxtools.model.level3.ProteinReference;
import org.junit.Assert;
import org.junit.Test;

public class UnionPropertyAccessorTest {
    @Test
    public void testUnion() {
        MockFactory factory = new MockFactory(BioPAXLevel.L3);
        Model model = factory.createModel();
        Protein p1 = (Protein)model.addNew(Protein.class, "P1");
        ProteinReference r1 = (ProteinReference)model.addNew(ProteinReference.class, "R1");
        p1.setEntityReference((EntityReference)r1);
        Dna dna1 = (Dna)model.addNew(Dna.class, "DNA1");
        DnaReference dnar1 = (DnaReference)model.addNew(DnaReference.class, "DNAR1");
        dna1.setEntityReference((EntityReference)dnar1);
        BioSource human = (BioSource)model.addNew(BioSource.class, "human");
        human.setStandardName("Homo Sapiens");
        BioSource alien = (BioSource)model.addNew(BioSource.class, "alien");
        alien.setStandardName("Green Oval Heads");
        dnar1.setOrganism(human);
        r1.setOrganism(alien);
        Complex complex = (Complex)model.addNew(Complex.class, "complex");
        complex.addComponent((PhysicalEntity)dna1);
        complex.addComponent((PhysicalEntity)p1);
        PathAccessor pa = new PathAccessor("Complex/component/entityReference/organism", BioPAXLevel.L3);
        Set valueFromBean = pa.getValueFromBean((BioPAXElement)complex);
        Assert.assertTrue((boolean)valueFromBean.containsAll(Arrays.asList(human, alien)));
        Assert.assertTrue((valueFromBean.size() == 2 ? 1 : 0) != 0);
    }
}

