/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl.level3;

import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.Evidence;
import org.biopax.paxtools.model.level3.EvidenceCodeVocabulary;
import org.biopax.paxtools.model.level3.UnificationXref;
import org.biopax.paxtools.model.level3.Xref;
import org.junit.Assert;
import org.junit.Test;

public class EvidenceImplTest {
    @Test
    public final void testSemanticallyEquivalent() {
        Model m = BioPAXLevel.L3.getDefaultFactory().createModel();
        UnificationXref x = (UnificationXref)m.addNew(UnificationXref.class, "ExpType_MI_0492");
        x.setDb("MI");
        x.setId("MI:0492");
        EvidenceCodeVocabulary ecv = (EvidenceCodeVocabulary)m.addNew(EvidenceCodeVocabulary.class, "EvidenceCodeVocab_1");
        ecv.addTerm("in vitro");
        ecv.addXref((Xref)x);
        Evidence inVitro = (Evidence)m.addNew(Evidence.class, "Evidence_InVitro");
        inVitro.addEvidenceCode(ecv);
        x = (UnificationXref)m.addNew(UnificationXref.class, "ExpType_MI_0493");
        x.setDb("MI");
        x.setId("MI:0493");
        ecv = (EvidenceCodeVocabulary)m.addNew(EvidenceCodeVocabulary.class, "EvidenceCodeVocab_2");
        ecv.addTerm("in vivo");
        ecv.addXref((Xref)x);
        Evidence inVivo = (Evidence)m.addNew(Evidence.class, "Evidence_InVivo");
        Assert.assertFalse((boolean)inVitro.isEquivalent((BioPAXElement)inVivo));
    }
}

