/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl.level3;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.EnumeratedPropertyEditor;
import org.biopax.paxtools.controller.ObjectPropertyEditor;
import org.biopax.paxtools.controller.PrimitivePropertyEditor;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.controller.StringPropertyEditor;
import org.biopax.paxtools.impl.BioPAXFactoryAdaptor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.level3.Entity;
import org.biopax.paxtools.util.IllegalBioPAXArgumentException;

public class MockFactory
extends BioPAXFactoryAdaptor {
    private static final List<String> strings = Arrays.asList(" ", "alpha", "beta", "gamma", "_~/-\\\t\b,", "\udddd\ucccc\uaaaa\ubbbb");
    private static final List<Float> floats = Arrays.asList(Float.valueOf(Float.MAX_VALUE), Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(Float.MIN_VALUE));
    private static final List<Double> doubles = Arrays.asList(Double.MAX_VALUE, 1.0, 0.0, Double.MIN_VALUE);
    private static final List<Integer> ints = Arrays.asList(Integer.MAX_VALUE, 1, 0, -2147483647);
    private static final List<Boolean> booleans = Arrays.asList(Boolean.TRUE, Boolean.FALSE);
    private static final String base = "mock://id/";
    private int id = 0;
    private final EditorMap map = SimpleEditorMap.L3;
    private BioPAXLevel level;

    public MockFactory(BioPAXLevel level) {
        this.level = level;
    }

    public <T extends BioPAXElement> T create(Class<T> aClass, String uri) {
        BioPAXElement t = this.getLevel().getDefaultFactory().create(aClass, uri);
        this.populateMock(t);
        return (T)t;
    }

    public BioPAXElement create(String localName, String uri) {
        BioPAXElement bpe = this.getLevel().getDefaultFactory().create(localName, uri);
        this.populateMock(bpe);
        return bpe;
    }

    private void populateMock(BioPAXElement bpe) {
        Set propertyEditors = this.map.getEditorsOf(bpe);
        for (PropertyEditor propertyEditor : propertyEditors) {
            boolean multiple = propertyEditor.isMultipleCardinality();
            Object value = null;
            if (propertyEditor instanceof StringPropertyEditor) {
                value = this.getStrings(bpe, multiple);
            } else {
                Class range = propertyEditor.getRange();
                if (propertyEditor instanceof PrimitivePropertyEditor) {
                    if (range == Float.TYPE) {
                        value = multiple ? floats : floats.get(1);
                    } else if (range == Double.TYPE) {
                        value = multiple ? doubles : doubles.get(1);
                    } else if (range == Integer.TYPE) {
                        value = multiple ? ints : ints.get(1);
                    } else if (range == Boolean.class) {
                        value = multiple ? booleans : booleans.get(1);
                    }
                } else if (propertyEditor instanceof EnumeratedPropertyEditor) {
                    Field[] fields = range.getFields();
                    if (multiple) {
                        value = new HashSet();
                    }
                    for (Field field : fields) {
                        if (!field.isEnumConstant()) continue;
                        try {
                            if (multiple) {
                                ((Set)value).add(field.get(bpe));
                                continue;
                            }
                            value = field.get(bpe);
                            break;
                        }
                        catch (IllegalAccessException e) {
                            throw new IllegalBioPAXArgumentException();
                        }
                    }
                } else if (!Entity.class.isAssignableFrom(range)) {
                    value = multiple ? this.createRestrictedMock((ObjectPropertyEditor)propertyEditor, bpe, 3) : this.createRestrictedMock((ObjectPropertyEditor)propertyEditor, bpe, 1).iterator().next();
                }
            }
            if (value == null || !multiple) continue;
            Collection values = (Collection)value;
            if (!values.isEmpty()) {
                Integer max = propertyEditor.getMaxCardinality(bpe.getModelInterface());
                values = this.upToMax(values, max);
                for (Object o : values) {
                    propertyEditor.setValueToBean(o, bpe);
                }
                continue;
            }
            propertyEditor.setValueToBean(value, bpe);
        }
    }

    private Object getStrings(BioPAXElement bpe, boolean multiple) {
        if (multiple) {
            ArrayList<String> list = new ArrayList<String>(6);
            for (String str : strings) {
                list.add(bpe.getRDFId() + str);
            }
            return list;
        }
        return bpe.getRDFId() + strings.get(4);
    }

    private HashSet<BioPAXElement> createRestrictedMock(ObjectPropertyEditor propertyEditor, BioPAXElement bpe, int k) {
        HashSet<BioPAXElement> hashSet = new HashSet<BioPAXElement>();
        Set rranges = propertyEditor.getRestrictedRangesFor(bpe.getModelInterface());
        for (Class rrange : rranges) {
            hashSet.add(this.createMock(rrange, bpe.getModelInterface()));
        }
        return hashSet;
    }

    private BioPAXElement createMock(Class toCreate, Class domain) {
        assert (domain != null);
        Class actual = this.findConcreteMockClass(toCreate, domain);
        if (actual != null) {
            return this.map.getLevel().getDefaultFactory().create(actual, base + this.id++);
        }
        return null;
    }

    private Class findConcreteMockClass(Class toCreate, Class domain) {
        Class actual = null;
        if (this.map.getLevel().getDefaultFactory().canInstantiate(toCreate) && !toCreate.isAssignableFrom(domain)) {
            actual = toCreate;
        } else {
            Set classesOf = this.map.getKnownSubClassesOf(toCreate);
            for (Class subclass : classesOf) {
                if (subclass.isAssignableFrom(domain) || subclass == toCreate || !subclass.getPackage().getName().startsWith("org.biopax.paxtools.model")) continue;
                actual = this.findConcreteMockClass(subclass, domain);
                break;
            }
        }
        return actual;
    }

    private Collection upToMax(Collection values, Integer max) {
        int size = values.size();
        if (max != null && max < size) {
            values = new ArrayList(values);
            for (int i = size - 1; i == max; --i) {
                ((List)values).remove(i);
            }
            assert (values.size() == max.intValue());
        }
        return values;
    }

    public <T extends BioPAXElement> T createInstance(Class<T> aClass, String uri) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        throw new UnsupportedOperationException();
    }

    public BioPAXLevel getLevel() {
        return this.level;
    }
}

