/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.biopax.paxtools.io.BioPAXIOHandler;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXFactory;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.BiochemicalReaction;
import org.biopax.paxtools.model.level3.Catalysis;
import org.biopax.paxtools.model.level3.CellularLocationVocabulary;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.ControlType;
import org.biopax.paxtools.model.level3.Entity;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.MolecularInteraction;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Process;
import org.biopax.paxtools.model.level3.Protein;
import org.biopax.paxtools.model.level3.ProteinReference;
import org.biopax.paxtools.model.level3.Stoichiometry;
import org.junit.Assert;
import org.junit.Test;

public class SimpleIOHandlerTest {
    private void outputModel(Model m, OutputStream out) {
        new SimpleIOHandler().convertToOWL(m, out);
    }

    @Test
    public final void testExportL2() throws FileNotFoundException {
        Model model = BioPAXLevel.L2.getDefaultFactory().createModel();
        FileOutputStream out = new FileOutputStream(this.getClass().getResource("").getFile() + File.separator + "simple.owl");
        this.outputModel(model, out);
    }

    @Test
    public final void testReadWriteL2() throws IOException {
        SimpleIOHandler io = new SimpleIOHandler();
        Model model = SimpleIOHandlerTest.getL2Model((BioPAXIOHandler)io);
        Assert.assertNotNull((Object)model);
        Assert.assertFalse((boolean)model.getObjects().isEmpty());
        System.out.println("Model has " + model.getObjects().size() + " objects)");
        FileOutputStream out = new FileOutputStream(this.getClass().getResource("").getFile() + File.separator + "simpleReadWrite.owl");
        io.convertToOWL(model, (OutputStream)out);
    }

    public static Model getL2Model(BioPAXIOHandler io) {
        String s = "L2" + File.separator + "biopax_id_557861_mTor_signaling.owl";
        System.out.println("file = " + s);
        System.out.println("starting " + s);
        InputStream in = SimpleIOHandlerTest.class.getClassLoader().getResourceAsStream(s);
        Assert.assertNotNull((Object)in);
        return io.convertFromOWL(in);
    }

    @Test
    public final void testReadWriteL3() throws IOException {
        SimpleIOHandler io = new SimpleIOHandler();
        Model model = SimpleIOHandlerTest.getL3Model((BioPAXIOHandler)io);
        Assert.assertNotNull((Object)model);
        Assert.assertFalse((boolean)model.getObjects().isEmpty());
        System.out.println("Model has " + model.getObjects().size() + " objects)");
        FileOutputStream out = new FileOutputStream(this.getClass().getResource("").getFile() + File.separator + "simpleReadWrite.owl");
        io.convertToOWL(model, (OutputStream)out);
    }

    public static Model getL3Model(BioPAXIOHandler io) {
        String s = "L3" + File.separator + "biopax3-short-metabolic-pathway.owl";
        System.out.println("file = " + s);
        System.out.println("starting " + s);
        InputStream in = SimpleIOHandlerTest.class.getClassLoader().getResourceAsStream(s);
        return io.convertFromOWL(in);
    }

    @Test
    public final void testDuplicateNamesByExporter() throws IOException {
        BioPAXFactory factory = BioPAXLevel.L3.getDefaultFactory();
        Protein p = (Protein)factory.create(Protein.class, "myProtein");
        String name = "aDisplayName";
        p.setDisplayName(name);
        p.addComment("Display Name should not be repeated again in the Name property!");
        Model m = factory.createModel();
        m.add((BioPAXElement)p);
        FileOutputStream out = new FileOutputStream(this.getClass().getResource("").getFile() + File.separator + "testDuplicateNamesByExporter.xml");
        this.outputModel(m, out);
        BufferedReader in = new BufferedReader(new FileReader(this.getClass().getResource("").getFile() + File.separator + "testDuplicateNamesByExporter.xml"));
        char[] buf = new char[1000];
        in.read(buf);
        String xml = new String(buf);
        if (xml.indexOf(name) != xml.lastIndexOf(name)) {
            Assert.fail((String)"displayName gets duplicated by the SimpleIOHandler!");
        }
    }

    @Test
    public final void testhibernateFile() throws IOException {
        System.out.println("export");
        BioPAXFactory factory = BioPAXLevel.L3.getDefaultFactory();
        Model m = factory.createModel();
        Protein p = (Protein)m.addNew(Protein.class, "myProtein");
        MolecularInteraction mi = (MolecularInteraction)m.addNew(MolecularInteraction.class, "myInteraction");
        mi.addParticipant((Entity)p);
        FileOutputStream out = new FileOutputStream(this.getClass().getClassLoader().getResource("").getPath() + File.separator + "hibtest.owl");
        this.outputModel(m, out);
    }

    @Test
    public final void testBioPAXDocument() {
        String ID_COMPARTMENT_1 = "compartment_1";
        String ID_PROTEIN_1 = "PROTEIN_1";
        String ID_PROTEIN_2 = "PROTEIN_2";
        String ID_PROTEIN_3 = "PROTEIN_3";
        String ID_PROTEIN_REFERENCE_1 = "PROTEIN_REFERENCE_1";
        String ID_PROTEIN_REFERENCE_2 = "PROTEIN_REFERENCE_2";
        String ID_PROTEIN_REFERENCE_3 = "PROTEIN_REFERENCE_3";
        BioPAXFactory level3Factory = BioPAXLevel.L3.getDefaultFactory();
        Model biopaxModel = level3Factory.createModel();
        CellularLocationVocabulary clv = (CellularLocationVocabulary)biopaxModel.addNew(CellularLocationVocabulary.class, ID_COMPARTMENT_1);
        String compartmentName = "golgi";
        clv.addTerm(compartmentName);
        Protein p1 = (Protein)biopaxModel.addNew(Protein.class, ID_PROTEIN_1);
        p1.setDisplayName("PE-Pro-BACE-1");
        Protein p2 = (Protein)biopaxModel.addNew(Protein.class, ID_PROTEIN_2);
        p2.setDisplayName("PE-BACE-1");
        Protein p3 = (Protein)biopaxModel.addNew(Protein.class, ID_PROTEIN_3);
        p3.setDisplayName("Furin");
        p1.setCellularLocation(clv);
        p2.setCellularLocation(clv);
        p3.setCellularLocation(clv);
        ProteinReference pr1 = (ProteinReference)biopaxModel.addNew(ProteinReference.class, ID_PROTEIN_REFERENCE_1);
        pr1.setStandardName("Pro-BACE-1");
        p1.setEntityReference((EntityReference)pr1);
        Stoichiometry stoichiometry1 = (Stoichiometry)biopaxModel.addNew(Stoichiometry.class, "ST1");
        stoichiometry1.setPhysicalEntity((PhysicalEntity)p1);
        stoichiometry1.setStoichiometricCoefficient(1.0f);
        ProteinReference pr2 = (ProteinReference)biopaxModel.addNew(ProteinReference.class, ID_PROTEIN_REFERENCE_2);
        pr2.setStandardName("BACE-1");
        p2.setEntityReference((EntityReference)pr2);
        Stoichiometry stoichiometry2 = (Stoichiometry)biopaxModel.addNew(Stoichiometry.class, "ST2");
        stoichiometry2.setPhysicalEntity((PhysicalEntity)p2);
        stoichiometry2.setStoichiometricCoefficient(1.0f);
        ProteinReference pr3 = (ProteinReference)biopaxModel.addNew(ProteinReference.class, ID_PROTEIN_REFERENCE_3);
        pr3.setStandardName("Furin");
        p3.setEntityReference((EntityReference)pr3);
        Stoichiometry stoichiometry3 = (Stoichiometry)biopaxModel.addNew(Stoichiometry.class, "ST3");
        stoichiometry3.setPhysicalEntity((PhysicalEntity)p3);
        stoichiometry3.setStoichiometricCoefficient(1.0f);
        BiochemicalReaction r = (BiochemicalReaction)biopaxModel.addNew(BiochemicalReaction.class, "r1");
        r.addLeft((PhysicalEntity)p1);
        r.addRight((PhysicalEntity)p2);
        Control c = (Control)biopaxModel.addNew(Catalysis.class, "cat1");
        c.setControlType(ControlType.ACTIVATION);
        c.addControlled((Process)r);
        try {
            System.out.println("test");
            File f = new File(this.getClass().getClassLoader().getResource("").getPath() + File.separator + "test.owl");
            FileOutputStream anOutputStream = new FileOutputStream(f);
            this.outputModel(biopaxModel, anOutputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

