/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.controller;

import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.controller.Traverser;
import org.biopax.paxtools.controller.Visitor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.util.Filter;

public abstract class AbstractTraverser
extends Traverser
implements Visitor {
    private final Stack<BioPAXElement> visited = new Stack();
    private final Stack<String> props = new Stack();
    private static final Log log = LogFactory.getLog(AbstractTraverser.class);

    public AbstractTraverser(EditorMap editorMap, Filter<PropertyEditor> ... filters) {
        super(editorMap, null, filters);
        this.setVisitor(this);
    }

    protected Stack<BioPAXElement> getVisited() {
        return this.visited;
    }

    public Stack<String> getProps() {
        return this.props;
    }

    protected abstract void visit(Object var1, BioPAXElement var2, Model var3, PropertyEditor<?, ?> var4);

    @Override
    public void visit(BioPAXElement domain, Object range, Model model, PropertyEditor<?, ?> editor) {
        if (range instanceof BioPAXElement) {
            if (this.visited.contains(range)) {
                log.info((Object)(((BioPAXElement)range).getRDFId() + " already visited (cycle!): " + this.visited.toString()));
                return;
            }
            this.visited.push((BioPAXElement)range);
        }
        this.props.push(editor.getProperty());
        this.visit(range, domain, model, editor);
        this.props.pop();
        if (range instanceof BioPAXElement) {
            this.visited.pop();
        }
    }

    public void reset() {
        this.visited.clear();
        this.props.clear();
    }
}

