/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.controller;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.controller.AbstractTraverser;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.ObjectPropertyEditor;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.util.Filter;

public class PropertyReasoner
extends AbstractTraverser {
    private static final Log LOG = LogFactory.getLog(PropertyReasoner.class);
    private String property;
    private final Set<Class<? extends BioPAXElement>> domains;
    private boolean override;
    private final Stack<Set> valueStack;
    private boolean generateComments;

    public PropertyReasoner(String propertyName, EditorMap editorMap, Filter<PropertyEditor> ... propertyFilters) {
        super(editorMap, propertyFilters);
        this.property = propertyName;
        this.domains = new HashSet<Class<? extends BioPAXElement>>();
        this.domains.add(BioPAXElement.class);
        this.override = false;
        this.valueStack = new Stack();
        this.generateComments = true;
    }

    public PropertyReasoner(String property, EditorMap editorMap) {
        this(property, editorMap, new Filter<PropertyEditor>(){

            @Override
            public boolean filter(PropertyEditor editor) {
                return editor instanceof ObjectPropertyEditor && !editor.getProperty().equals("nextStep") && !editor.getProperty().equals("NEXT-STEP");
            }
        });
    }

    public String getPropertyName() {
        return this.property;
    }

    public void setPropertyName(String propertyName) {
        this.property = propertyName;
    }

    public void setDomains(Class<? extends BioPAXElement> ... domains) {
        this.domains.clear();
        if (domains.length > 0) {
            this.domains.addAll(Arrays.asList(domains));
        } else {
            this.domains.add(BioPAXElement.class);
        }
    }

    public boolean isOverride() {
        return this.override;
    }

    protected void setOverride(boolean override) {
        this.override = override;
    }

    public boolean isGenerateComments() {
        return this.generateComments;
    }

    public void setGenerateComments(boolean generateComments) {
        this.generateComments = generateComments;
    }

    public void traverse(BioPAXElement bpe, Model model) {
        PropertyEditor<BioPAXElement, ?> editor;
        block10: {
            block11: {
                Set existingValues;
                block12: {
                    Set value;
                    block13: {
                        if (bpe == null) {
                            return;
                        }
                        editor = this.editorMap.getEditorForProperty(this.property, bpe.getModelInterface());
                        if (editor == null) break block10;
                        if (!PropertyReasoner.isInstanceofOneOf(this.domains, bpe)) break block11;
                        existingValues = editor.getValueFromBean(bpe);
                        if (editor.isMultipleCardinality()) break block12;
                        value = this.valueStack.peek();
                        assert (value.isEmpty() || value.size() == 1);
                        assert (existingValues.isEmpty() || existingValues.size() == 1);
                        if (!editor.isUnknown(existingValues)) break block13;
                        if (!editor.isUnknown(value)) {
                            editor.setValueToBean(value, bpe);
                            this.comment(bpe, value, false);
                        }
                        break block11;
                    }
                    if (!this.override || ((Object)existingValues).equals(value) || existingValues.containsAll(value)) break block11;
                    editor.setValueToBean(value, bpe);
                    this.comment(bpe, existingValues, true);
                    this.comment(bpe, value, false);
                    break block11;
                }
                if (this.override && !this.valueStack.contains(existingValues)) {
                    for (Object object : existingValues) {
                        editor.removeValueFromBean(object, bpe);
                        this.comment(bpe, object, true);
                    }
                }
                for (Set set : this.valueStack) {
                    if (existingValues.containsAll(set)) continue;
                    editor.setValueToBean(set, bpe);
                    this.comment(bpe, set, false);
                }
            }
            if (!this.override) {
                this.valueStack.push(editor.getValueFromBean(bpe));
            } else {
                this.valueStack.push(this.valueStack.peek());
            }
        }
        super.traverse(bpe, model);
        if (editor != null) {
            this.valueStack.pop();
        }
    }

    protected void visit(Object range, BioPAXElement bpe, Model model, PropertyEditor editor) {
        if (range instanceof BioPAXElement) {
            this.traverse((BioPAXElement)range, model);
        }
    }

    private void comment(BioPAXElement bpe, Object v, boolean unset) {
        if (!this.generateComments) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"'comment' is called; won't write any BioPAX comments (generateComments==false)");
            }
            return;
        }
        PropertyEditor<BioPAXElement, ?> pe = this.editorMap.getEditorForProperty("comment", bpe.getModelInterface());
        if (pe == null) {
            pe = this.editorMap.getEditorForProperty("COMMENT", bpe.getModelInterface());
        }
        if (pe != null) {
            if (pe.isUnknown(v)) {
                return;
            }
            Object val = !pe.isMultipleCardinality() && v instanceof Set ? ((Set)v).iterator().next() : v;
            String msg = unset ? this.property + " REMOVED by a reasoner: " + this.list(val) : this.property + " ADDED by a reasoner: " + this.list(val);
            pe.setValueToBean(msg, bpe);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("BioPAX comment generated: " + msg));
            }
        }
    }

    private String list(Object val) {
        StringBuffer sb = new StringBuffer();
        if (val instanceof Set) {
            for (Object o : (Set)val) {
                sb.append(this.list(o)).append(" ");
            }
        } else if (val instanceof BioPAXElement) {
            sb.append(((BioPAXElement)val).getRDFId());
        } else {
            sb.append(val);
        }
        return sb.toString();
    }

    private static boolean isInstanceofOneOf(Collection<Class<? extends BioPAXElement>> classes, BioPAXElement obj) {
        for (Class<? extends BioPAXElement> c : classes) {
            if (!c.isInstance(obj)) continue;
            return true;
        }
        return false;
    }

    protected void run(BioPAXElement element, Object defaultValue) {
        this.valueStack.clear();
        Set<Object> valueInSet = defaultValue instanceof Set ? (Set<Object>)defaultValue : (defaultValue != null ? Collections.singleton(defaultValue) : (this.isOverride() ? Collections.singleton(null) : Collections.EMPTY_SET));
        this.valueStack.push(valueInSet);
        this.traverse(element, (Model)null);
    }

    public void clearProperty(BioPAXElement element) {
        boolean override = this.isOverride();
        this.setOverride(true);
        this.run(element, null);
        this.setOverride(override);
    }

    public void resetPropertyValue(BioPAXElement element, Object defaultValue) {
        if (defaultValue == null) {
            throw new NullPointerException("Consider using clearProperty() instead if you really want to set this property to null/unknown for the object and its children!");
        }
        boolean override = this.isOverride();
        this.setOverride(true);
        this.run(element, defaultValue);
        this.setOverride(override);
    }

    public void inferPropertyValue(BioPAXElement element, Object addValue) {
        boolean override = this.isOverride();
        this.setOverride(false);
        this.run(element, addValue);
        this.setOverride(override);
    }

    public void inferPropertyValue(BioPAXElement element) {
        boolean override = this.isOverride();
        this.setOverride(false);
        this.run(element, null);
        this.setOverride(override);
    }
}

