/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.controller;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.ObjectPropertyEditor;
import org.biopax.paxtools.controller.PropertyEditor;
import org.biopax.paxtools.controller.PropertyFilterBilinked;
import org.biopax.paxtools.controller.Traverser;
import org.biopax.paxtools.controller.Visitor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.util.Filter;

public class TraverserBilinked
extends Traverser {
    private boolean isInverseOnly = false;
    private static final Log log = LogFactory.getLog(TraverserBilinked.class);

    public TraverserBilinked(EditorMap editorMap, Visitor visitor, PropertyFilterBilinked ... filters) {
        super(editorMap, visitor, filters);
    }

    public boolean isInverseOnly() {
        return this.isInverseOnly;
    }

    public void setInverseOnly(boolean isInverseOnly) {
        this.isInverseOnly = isInverseOnly;
    }

    public void traverse(BioPAXElement element, Model model) {
        Set<ObjectPropertyEditor> editors;
        if (!this.isInverseOnly) {
            super.traverse(element, model);
        }
        if ((editors = this.editorMap.getInverseEditorsOf(element)) == null) {
            log.warn((Object)("No editors for : " + element.getModelInterface()));
            return;
        }
        for (ObjectPropertyEditor editor : editors) {
            HashSet valueSet;
            if (!this.filterInverse(editor) || (valueSet = new HashSet(editor.getInverseAccessor().getValueFromBean(element))).isEmpty()) continue;
            for (BioPAXElement value : valueSet) {
                if (value == null) continue;
                this.visitor.visit(element, value, model, editor);
            }
        }
    }

    protected boolean filterInverse(PropertyEditor editor) {
        for (Filter filter : this.filters) {
            if (((PropertyFilterBilinked)filter).filterInverse(editor)) continue;
            return false;
        }
        return true;
    }
}

