/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.biopax.paxtools.model.BioPAXElement;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;

@Entity
@Proxy(proxyClass=BioPAXElement.class)
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(length=40)
@DynamicUpdate
@DynamicInsert
@NamedQueries(value={@NamedQuery(name="org.biopax.paxtools.impl.BioPAXElementExists", query="select 1 from BioPAXElementImpl where pk=:md5uri")})
public abstract class BioPAXElementImpl
implements BioPAXElement {
    public static final String FIELD_AVAILABILITY = "availability";
    public static final String FIELD_COMMENT = "comment";
    public static final String FIELD_KEYWORD = "keyword";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_TERM = "term";
    public static final String FIELD_XREFDB = "xrefdb";
    public static final String FIELD_XREFID = "xrefid";
    public static final String FIELD_ECNUMBER = "ecnumber";
    public static final String FIELD_SEQUENCE = "sequence";
    public static final String FIELD_ORGANISM = "organism";
    public static final String FIELD_DATASOURCE = "dataSource";
    public static final String FIELD_PATHWAY = "pathway";
    public static final String FILTER_BY_ORGANISM = "organism";
    public static final String FILTER_BY_DATASOURCE = "datasource";
    private String uri;
    private Map<String, Object> annotations = new HashMap<String, Object>();
    private String _pk;
    @Version
    private long version;

    @Id
    @Column(name="pk", length=32)
    public String getPk() {
        return this._pk;
    }

    private void setPk(String pk) {
        this._pk = pk;
    }

    @Lob
    @Column(nullable=false)
    private String getUri() {
        return this.uri;
    }

    private void setUri(String uri) {
        this.uri = uri;
    }

    @Override
    @Transient
    public boolean isEquivalent(BioPAXElement element) {
        return this.equals(element) || this.semanticallyEquivalent(element);
    }

    protected boolean semanticallyEquivalent(BioPAXElement element) {
        return false;
    }

    @Override
    public int equivalenceCode() {
        return this.uri.hashCode();
    }

    @Override
    @Transient
    public String getRDFId() {
        return this.uri;
    }

    private synchronized void setRDFId(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        this.uri = uri;
        this._pk = BioPAXElementImpl.md5hex(this.uri);
    }

    public String toString() {
        return this.uri;
    }

    @Override
    @Transient
    public Map<String, Object> getAnnotations() {
        return this.annotations;
    }

    private static String md5hex(String id) {
        MessageDigest md5;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Cannot instantiate MD5 MessageDigest!", e);
        }
        byte[] digest = md5.digest(id.getBytes());
        StringBuffer sb = new StringBuffer();
        for (byte b : digest) {
            sb.append(Integer.toHexString(b & 0xFF | 0x100).substring(1, 3));
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        return obj instanceof BioPAXElement && this.getModelInterface() == ((BioPAXElement)obj).getModelInterface() && this.uri.equals(((BioPAXElement)obj).getRDFId());
    }

    public int hashCode() {
        return (this.getModelInterface().getCanonicalName() + this.uri).hashCode();
    }
}

