/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl.level3;

import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinTable;
import javax.persistence.Transient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.impl.level3.CellVocabularyImpl;
import org.biopax.paxtools.impl.level3.XReferrableImpl;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.ControlledVocabulary;
import org.biopax.paxtools.model.level3.UnificationXref;
import org.biopax.paxtools.model.level3.Xref;
import org.biopax.paxtools.util.ClassFilterSet;
import org.biopax.paxtools.util.SetEquivalenceChecker;
import org.biopax.paxtools.util.SetStringBridge;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Indexed;

@Entity
@Proxy(proxyClass=ControlledVocabulary.class)
@Indexed
@DynamicUpdate
@DynamicInsert
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class ControlledVocabularyImpl
extends XReferrableImpl
implements ControlledVocabulary {
    private static final Log LOG = LogFactory.getLog(CellVocabularyImpl.class);
    private Set<String> term = new HashSet<String>();
    private static final Pattern PATTERN = Pattern.compile("\\]|\\[");

    @Transient
    public Class<? extends ControlledVocabulary> getModelInterface() {
        return ControlledVocabulary.class;
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ElementCollection(fetch=FetchType.EAGER)
    @JoinTable(name="term")
    @Field(name="term", analyze=Analyze.YES)
    @FieldBridge(impl=SetStringBridge.class)
    public Set<String> getTerm() {
        return this.term;
    }

    public void setTerm(Set<String> term) {
        this.term = term;
    }

    @Override
    public void addTerm(String term) {
        if (term != null && term.length() > 0) {
            this.term.add(term);
        }
    }

    @Override
    public void removeTerm(String term) {
        if (term != null) {
            this.term.remove(term);
        }
    }

    @Override
    protected boolean semanticallyEquivalent(BioPAXElement element) {
        if (!(element instanceof ControlledVocabulary)) {
            return false;
        }
        ControlledVocabulary that = (ControlledVocabulary)element;
        HashSet<String> terms = new HashSet<String>(this.term.size());
        terms.addAll(this.term);
        terms.retainAll(that.getTerm());
        return this.getModelInterface().equals(that.getModelInterface()) && (this.term.isEmpty() && that.getTerm().isEmpty() || !terms.isEmpty()) && SetEquivalenceChecker.hasEquivalentIntersection(new ClassFilterSet<Xref, UnificationXref>(this.getXref(), UnificationXref.class), new ClassFilterSet<Xref, UnificationXref>(that.getXref(), UnificationXref.class));
    }

    @Override
    public String toString() {
        try {
            return PATTERN.matcher(this.term.toString()).replaceAll("");
        }
        catch (Exception e) {
            LOG.warn((Object)"toString(): ", (Throwable)e);
            return this.getRDFId();
        }
    }
}

