/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl.level3;

import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Transient;
import org.biopax.paxtools.impl.level3.InteractionImpl;
import org.biopax.paxtools.impl.level3.PhysicalEntityImpl;
import org.biopax.paxtools.impl.level3.StoichiometryImpl;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.ConversionDirectionType;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Stoichiometry;
import org.biopax.paxtools.util.BiopaxSafeSet;
import org.biopax.paxtools.util.SetEquivalenceChecker;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;
import org.hibernate.search.annotations.Indexed;

@Entity
@Proxy(proxyClass=Conversion.class)
@Indexed
@DynamicUpdate
@DynamicInsert
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class ConversionImpl
extends InteractionImpl
implements Conversion {
    private Set<PhysicalEntity> right;
    private Set<PhysicalEntity> left = new BiopaxSafeSet<PhysicalEntity>();
    private ConversionDirectionType conversionDirection;
    private Set<Stoichiometry> participantStoichiometry;
    private Boolean spontaneous;

    public ConversionImpl() {
        this.right = new BiopaxSafeSet<PhysicalEntity>();
        this.participantStoichiometry = new BiopaxSafeSet<Stoichiometry>();
    }

    @Transient
    public Class<? extends Conversion> getModelInterface() {
        return Conversion.class;
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ManyToMany(targetEntity=PhysicalEntityImpl.class)
    @JoinTable(name="rightParticipant")
    public Set<PhysicalEntity> getRight() {
        return this.right;
    }

    protected void setRight(Set<PhysicalEntity> right) {
        this.right = right;
    }

    @Override
    public void addRight(PhysicalEntity right) {
        if (right != null) {
            this.right.add(right);
            super.addParticipant(right);
        }
    }

    @Override
    public void removeRight(PhysicalEntity right) {
        if (right != null) {
            super.removeParticipant(right);
            this.right.remove(right);
        }
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ManyToMany(targetEntity=PhysicalEntityImpl.class)
    @JoinTable(name="leftParticipant")
    public Set<PhysicalEntity> getLeft() {
        return this.left;
    }

    protected void setLeft(Set<PhysicalEntity> left) {
        this.left = left;
    }

    @Override
    public void addLeft(PhysicalEntity left) {
        if (left != null) {
            this.left.add(left);
            super.addParticipant(left);
        }
    }

    @Override
    public void removeLeft(PhysicalEntity left) {
        if (left != null) {
            super.removeParticipant(left);
            this.left.remove(left);
        }
    }

    @Override
    public Boolean getSpontaneous() {
        return this.spontaneous;
    }

    @Override
    public void setSpontaneous(Boolean spontaneous) {
        this.spontaneous = spontaneous;
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ManyToMany(targetEntity=StoichiometryImpl.class)
    @JoinTable(name="conversionstoichiometry")
    public Set<Stoichiometry> getParticipantStoichiometry() {
        return this.participantStoichiometry;
    }

    @Override
    public void addParticipantStoichiometry(Stoichiometry participantStoichiometry) {
        this.participantStoichiometry.add(participantStoichiometry);
    }

    @Override
    public void removeParticipantStoichiometry(Stoichiometry participantStoichiometry) {
        this.participantStoichiometry.remove(participantStoichiometry);
    }

    protected void setParticipantStoichiometry(Set<Stoichiometry> participantStoichiometry) {
        this.participantStoichiometry = participantStoichiometry;
    }

    @Override
    @Enumerated
    public ConversionDirectionType getConversionDirection() {
        return this.conversionDirection;
    }

    @Override
    public void setConversionDirection(ConversionDirectionType spontanousType) {
        this.conversionDirection = spontanousType;
    }

    @Override
    protected boolean semanticallyEquivalent(BioPAXElement element) {
        Conversion that;
        if (element.getModelInterface() == this.getModelInterface() && (that = (Conversion)element).getSpontaneous() == this.getSpontaneous() && that.getConversionDirection() == this.getConversionDirection()) {
            if (SetEquivalenceChecker.isEquivalent(this.getLeft(), that.getLeft())) {
                return SetEquivalenceChecker.isEquivalent(this.getRight(), that.getRight());
            }
            if (SetEquivalenceChecker.isEquivalent(this.getLeft(), that.getRight())) {
                return SetEquivalenceChecker.isEquivalent(this.getRight(), that.getLeft());
            }
        }
        return false;
    }

    @Override
    public int equivalenceCode() {
        return this.getEqCodeForSet(this.getLeft()) * this.getEqCodeForSet(this.getRight());
    }

    private int getEqCodeForSet(Set<PhysicalEntity> peSet) {
        int eqCode = 0;
        for (PhysicalEntity pe : peSet) {
            eqCode += pe.equivalenceCode();
        }
        return eqCode;
    }
}

