/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl.level3;

import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.impl.level3.EntityFeatureImpl;
import org.biopax.paxtools.impl.level3.EntityReferenceTypeVocabularyImpl;
import org.biopax.paxtools.impl.level3.EvidenceImpl;
import org.biopax.paxtools.impl.level3.NamedImpl;
import org.biopax.paxtools.impl.level3.SimplePhysicalEntityImpl;
import org.biopax.paxtools.model.level3.EntityFeature;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.EntityReferenceTypeVocabulary;
import org.biopax.paxtools.model.level3.Evidence;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.paxtools.util.BiopaxSafeSet;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;

@Entity
@Proxy(proxyClass=EntityReference.class)
@DynamicUpdate
@DynamicInsert
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public abstract class EntityReferenceImpl
extends NamedImpl
implements EntityReference {
    private final Log log = LogFactory.getLog(EntityReferenceImpl.class);
    private Set<EntityFeature> entityFeature = new BiopaxSafeSet<EntityFeature>();
    private Set<SimplePhysicalEntity> entityReferenceOf = new BiopaxSafeSet<SimplePhysicalEntity>();
    private Set<Evidence> evidence = new BiopaxSafeSet<Evidence>();
    Set<EntityReferenceTypeVocabulary> entityReferenceType = new BiopaxSafeSet<EntityReferenceTypeVocabulary>();
    Set<EntityReference> memberEntityReference = new BiopaxSafeSet<EntityReference>();
    private Set<EntityReference> ownerEntityReference = new BiopaxSafeSet<EntityReference>();

    @Transient
    public Class<? extends EntityReference> getModelInterface() {
        return EntityReference.class;
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @OneToMany(targetEntity=EntityFeatureImpl.class, mappedBy="entityFeatureOf")
    public Set<EntityFeature> getEntityFeature() {
        return this.entityFeature;
    }

    @Override
    public void addEntityFeature(EntityFeature entityFeature) {
        if (entityFeature != null) {
            EntityReference eFof = entityFeature.getEntityFeatureOf();
            if (eFof != null && !eFof.equals(this)) {
                this.log.warn((Object)("addEntityFeature: adding (to this " + this.getModelInterface().getSimpleName() + " " + this.getRDFId() + ") a " + entityFeature.getModelInterface().getSimpleName() + " " + entityFeature.getRDFId() + " that is already owned by another " + eFof.getModelInterface().getSimpleName() + " " + eFof.getRDFId()));
            }
            ((EntityFeatureImpl)entityFeature).setEntityFeatureOf(this);
            this.entityFeature.add(entityFeature);
        }
    }

    @Override
    public void removeEntityFeature(EntityFeature entityFeature) {
        if (entityFeature != null) {
            assert (entityFeature.getEntityFeatureOf() == this) : "attempt to remove not own EntityFeature!";
            if (entityFeature.getEntityFeatureOf() == this) {
                this.entityFeature.remove(entityFeature);
                ((EntityFeatureImpl)entityFeature).setEntityFeatureOf(null);
            }
        }
    }

    protected void setEntityFeature(Set<EntityFeature> entityFeature) {
        this.entityFeature = entityFeature;
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @OneToMany(targetEntity=SimplePhysicalEntityImpl.class, mappedBy="entityReferenceX")
    public Set<SimplePhysicalEntity> getEntityReferenceOf() {
        return this.entityReferenceOf;
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ManyToMany(targetEntity=EntityReferenceTypeVocabularyImpl.class)
    @JoinTable(name="entityReferenceType")
    public Set<EntityReferenceTypeVocabulary> getEntityReferenceType() {
        return this.entityReferenceType;
    }

    @Override
    public void addEntityReferenceType(EntityReferenceTypeVocabulary entityReferenceType) {
        if (entityReferenceType != null) {
            this.entityReferenceType.add(entityReferenceType);
        }
    }

    @Override
    public void removeEntityReferenceType(EntityReferenceTypeVocabulary entityReferenceType) {
        if (entityReferenceType != null) {
            this.entityReferenceType.remove(entityReferenceType);
        }
    }

    protected void setEntityReferenceType(Set<EntityReferenceTypeVocabulary> entityReferenceType) {
        this.entityReferenceType = entityReferenceType;
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ManyToMany(targetEntity=EntityReferenceImpl.class)
    @JoinTable(name="memberEntityReference")
    public Set<EntityReference> getMemberEntityReference() {
        return this.memberEntityReference;
    }

    @Override
    public void addMemberEntityReference(EntityReference memberEntity) {
        if (memberEntity != null) {
            this.memberEntityReference.add(memberEntity);
            memberEntity.getMemberEntityReferenceOf().add(this);
        }
    }

    @Override
    public void removeMemberEntityReference(EntityReference memberEntity) {
        if (memberEntity != null) {
            this.memberEntityReference.remove(memberEntity);
            memberEntity.getMemberEntityReferenceOf().remove(this);
        }
    }

    public void setMemberEntityReference(Set<EntityReference> memberEntity) {
        this.memberEntityReference = memberEntity;
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ManyToMany(targetEntity=EntityReferenceImpl.class, mappedBy="memberEntityReference")
    public Set<EntityReference> getMemberEntityReferenceOf() {
        return this.ownerEntityReference;
    }

    protected void setMemberEntityReferenceOf(Set<EntityReference> newOwnerEntityReferenceSet) {
        this.ownerEntityReference = newOwnerEntityReferenceSet;
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ManyToMany(targetEntity=EvidenceImpl.class)
    @JoinTable(name="evidence")
    public Set<Evidence> getEvidence() {
        return this.evidence;
    }

    @Override
    public void addEvidence(Evidence evidence2) {
        if (evidence2 != null) {
            this.evidence.add(evidence2);
        }
    }

    @Override
    public void removeEvidence(Evidence evidence2) {
        if (evidence2 != null) {
            this.evidence.remove(evidence2);
        }
    }

    public void setEvidence(Set<Evidence> evidence2) {
        this.evidence = evidence2;
    }

    protected void setEntityReferenceOf(Set<SimplePhysicalEntity> entityReferenceOf) {
        this.entityReferenceOf = entityReferenceOf;
    }

    protected void setMemberEntity(Set<EntityReference> memberEntity) {
        this.memberEntityReference = memberEntity;
    }
}

