/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl.level3;

import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import org.biopax.paxtools.impl.level3.NucleicAcidReferenceImpl;
import org.biopax.paxtools.impl.level3.SequenceLocationImpl;
import org.biopax.paxtools.impl.level3.SequenceRegionVocabularyImpl;
import org.biopax.paxtools.model.level3.NucleicAcidReference;
import org.biopax.paxtools.model.level3.NucleicAcidRegionReference;
import org.biopax.paxtools.model.level3.SequenceLocation;
import org.biopax.paxtools.model.level3.SequenceRegionVocabulary;
import org.biopax.paxtools.util.BiopaxSafeSet;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;

@Entity
@Proxy(proxyClass=NucleicAcidReference.class)
@DynamicUpdate
@DynamicInsert
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public abstract class NucleicAcidRegionReferenceImpl
extends NucleicAcidReferenceImpl
implements NucleicAcidRegionReference {
    private SequenceLocation absoluteRegion;
    private Set<SequenceRegionVocabulary> regionType = new BiopaxSafeSet<SequenceRegionVocabulary>();
    private NucleicAcidReference containerEntityReference;
    private Set<NucleicAcidReference> subRegionOf = new BiopaxSafeSet<NucleicAcidReference>();

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ManyToMany(targetEntity=NucleicAcidReferenceImpl.class, mappedBy="subRegion")
    public Set<NucleicAcidReference> getSubRegionOf() {
        return this.subRegionOf;
    }

    protected void setSubRegionOf(Set<NucleicAcidReference> subRegionOf) {
        this.subRegionOf = subRegionOf;
    }

    @Override
    @ManyToOne(targetEntity=SequenceLocationImpl.class)
    public SequenceLocation getAbsoluteRegion() {
        return this.absoluteRegion;
    }

    @Override
    public void setAbsoluteRegion(SequenceLocation absoluteRegion) {
        this.absoluteRegion = absoluteRegion;
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ManyToMany(targetEntity=SequenceRegionVocabularyImpl.class)
    @JoinTable(name="regionType")
    public Set<SequenceRegionVocabulary> getRegionType() {
        return this.regionType;
    }

    @Override
    public void addRegionType(SequenceRegionVocabulary regionType) {
        if (regionType != null) {
            this.regionType.add(regionType);
        }
    }

    @Override
    public void removeRegionType(SequenceRegionVocabulary regionType) {
        if (regionType != null) {
            this.regionType.remove(regionType);
        }
    }

    protected void setRegionType(Set<SequenceRegionVocabulary> regionType) {
        this.regionType = regionType;
    }
}

