/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl.level3;

import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.biopax.paxtools.impl.level3.BioSourceImpl;
import org.biopax.paxtools.impl.level3.ControlImpl;
import org.biopax.paxtools.impl.level3.PathwayStepImpl;
import org.biopax.paxtools.impl.level3.ProcessImpl;
import org.biopax.paxtools.model.level3.BioSource;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.Pathway;
import org.biopax.paxtools.model.level3.PathwayStep;
import org.biopax.paxtools.model.level3.Process;
import org.biopax.paxtools.util.BiopaxSafeSet;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;
import org.hibernate.search.annotations.Boost;
import org.hibernate.search.annotations.Indexed;

@Entity
@Proxy(proxyClass=Pathway.class)
@Indexed
@Boost(value=1.7f)
@DynamicUpdate
@DynamicInsert
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class PathwayImpl
extends ProcessImpl
implements Pathway {
    private Set<Process> pathwayComponent = new BiopaxSafeSet<Process>();
    private Set<PathwayStep> pathwayOrder = new BiopaxSafeSet<PathwayStep>();
    private BioSource organism;
    private Set<Control> controllerOf = new BiopaxSafeSet<Control>();

    @Transient
    public Class<? extends Pathway> getModelInterface() {
        return Pathway.class;
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ManyToMany(targetEntity=ProcessImpl.class)
    @JoinTable(name="pathwayComponent")
    public Set<Process> getPathwayComponent() {
        return this.pathwayComponent;
    }

    protected void setPathwayComponent(Set<Process> pathwayComponent2) {
        this.pathwayComponent = pathwayComponent2;
    }

    @Override
    public void addPathwayComponent(Process component) {
        if (component != null) {
            this.pathwayComponent.add(component);
            component.getPathwayComponentOf().add(this);
        }
    }

    @Override
    public void removePathwayComponent(Process component) {
        if (component != null) {
            this.pathwayComponent.remove(component);
            component.getPathwayComponentOf().remove(this);
        }
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @OneToMany(targetEntity=PathwayStepImpl.class, mappedBy="pathwayOrderOf")
    public Set<PathwayStep> getPathwayOrder() {
        return this.pathwayOrder;
    }

    protected void setPathwayOrder(Set<PathwayStep> pathwayOrder) {
        this.pathwayOrder = pathwayOrder;
    }

    @Override
    public void addPathwayOrder(PathwayStep pathwayOrder) {
        if (pathwayOrder != null) {
            this.pathwayOrder.add(pathwayOrder);
            ((PathwayStepImpl)pathwayOrder).setPathwayOrderOf(this);
        }
    }

    @Override
    public void removePathwayOrder(PathwayStep pathwayOrder) {
        if (pathwayOrder != null) {
            this.pathwayOrder.remove(pathwayOrder);
            ((PathwayStepImpl)pathwayOrder).setPathwayOrderOf(null);
        }
    }

    @Override
    @ManyToOne(targetEntity=BioSourceImpl.class)
    public BioSource getOrganism() {
        return this.organism;
    }

    @Override
    public void setOrganism(BioSource organism) {
        this.organism = organism;
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ManyToMany(targetEntity=ControlImpl.class, mappedBy="pathwayController")
    public Set<Control> getControllerOf() {
        return this.controllerOf;
    }

    protected void setControllerOf(Set<Control> controllerOf) {
        this.controllerOf = controllerOf;
    }
}

