/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl.level3;

import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.impl.level3.CellularLocationVocabularyImpl;
import org.biopax.paxtools.impl.level3.ComplexImpl;
import org.biopax.paxtools.impl.level3.ControlImpl;
import org.biopax.paxtools.impl.level3.EntityFeatureImpl;
import org.biopax.paxtools.impl.level3.EntityImpl;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.CellularLocationVocabulary;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.EntityFeature;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.util.BiopaxSafeSet;
import org.biopax.paxtools.util.DataSourceFilterFactory;
import org.biopax.paxtools.util.OrganismFilterFactory;
import org.biopax.paxtools.util.SetEquivalenceChecker;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;
import org.hibernate.search.annotations.Boost;
import org.hibernate.search.annotations.FullTextFilterDef;
import org.hibernate.search.annotations.FullTextFilterDefs;
import org.hibernate.search.annotations.Indexed;

@Entity
@Proxy(proxyClass=PhysicalEntity.class)
@Indexed
@Boost(value=1.3f)
@FullTextFilterDefs(value={@FullTextFilterDef(name="organism", impl=OrganismFilterFactory.class), @FullTextFilterDef(name="datasource", impl=DataSourceFilterFactory.class)})
@DynamicUpdate
@DynamicInsert
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class PhysicalEntityImpl
extends EntityImpl
implements PhysicalEntity {
    private CellularLocationVocabulary cellularLocation;
    private Set<PhysicalEntity> memberPhysicalEntity;
    private Set<Complex> componentOf;
    private Set<EntityFeature> feature;
    private Set<EntityFeature> notFeature;
    private Set<Control> controllerOf;
    private final Log log = LogFactory.getLog(PhysicalEntityImpl.class);
    private Set<PhysicalEntity> memberPhysicalEntityOf;

    public PhysicalEntityImpl() {
        this.feature = new BiopaxSafeSet<EntityFeature>();
        this.notFeature = new BiopaxSafeSet<EntityFeature>();
        this.controllerOf = new BiopaxSafeSet<Control>();
        this.componentOf = new BiopaxSafeSet<Complex>();
        this.memberPhysicalEntityOf = new BiopaxSafeSet<PhysicalEntity>();
        this.memberPhysicalEntity = new BiopaxSafeSet<PhysicalEntity>();
    }

    @Override
    @Transient
    public Class<? extends PhysicalEntity> getModelInterface() {
        return PhysicalEntity.class;
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ManyToMany(targetEntity=ComplexImpl.class, mappedBy="component")
    public Set<Complex> getComponentOf() {
        return this.componentOf;
    }

    @Override
    @ManyToOne(targetEntity=CellularLocationVocabularyImpl.class)
    public CellularLocationVocabulary getCellularLocation() {
        return this.cellularLocation;
    }

    @Override
    public void setCellularLocation(CellularLocationVocabulary location) {
        this.cellularLocation = location;
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ManyToMany(targetEntity=EntityFeatureImpl.class)
    @JoinTable(name="feature")
    public Set<EntityFeature> getFeature() {
        return this.feature;
    }

    @Override
    public void addFeature(EntityFeature feature) {
        if (feature != null) {
            this.checkAndAddFeature(feature, feature.getFeatureOf());
            this.feature.add(feature);
        }
    }

    @Override
    public void removeFeature(EntityFeature feature) {
        if (feature != null) {
            this.checkAndRemoveFeature(feature, feature.getFeatureOf());
            this.feature.remove(feature);
        }
    }

    protected void setFeature(Set<EntityFeature> feature) {
        this.feature = feature;
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ManyToMany(targetEntity=EntityFeatureImpl.class)
    @JoinTable(name="notfeature")
    public Set<EntityFeature> getNotFeature() {
        return this.notFeature;
    }

    @Override
    public void addNotFeature(EntityFeature feature) {
        if (feature != null) {
            this.checkAndAddFeature(feature, feature.getNotFeatureOf());
            this.notFeature.add(feature);
        }
    }

    @Override
    public void removeNotFeature(EntityFeature feature) {
        if (feature != null) {
            this.checkAndRemoveFeature(feature, feature.getNotFeatureOf());
            this.notFeature.remove(feature);
        }
    }

    protected void setNotFeature(Set<EntityFeature> featureSet) {
        this.notFeature = featureSet;
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ManyToMany(targetEntity=PhysicalEntityImpl.class)
    @JoinTable(name="memberPhysicalEntity")
    public Set<PhysicalEntity> getMemberPhysicalEntity() {
        return this.memberPhysicalEntity;
    }

    @Override
    public void addMemberPhysicalEntity(PhysicalEntity newMember) {
        if (newMember != null) {
            this.memberPhysicalEntity.add(newMember);
            newMember.getMemberPhysicalEntityOf().add(this);
        }
    }

    @Override
    public void removeMemberPhysicalEntity(PhysicalEntity oldMember) {
        if (oldMember != null) {
            this.memberPhysicalEntity.remove(oldMember);
            oldMember.getMemberPhysicalEntityOf().remove(this);
        }
    }

    protected void setMemberPhysicalEntity(Set<PhysicalEntity> memberPhysicalEntity) {
        this.memberPhysicalEntity = memberPhysicalEntity;
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ManyToMany(targetEntity=PhysicalEntityImpl.class, mappedBy="memberPhysicalEntity")
    public Set<PhysicalEntity> getMemberPhysicalEntityOf() {
        return this.memberPhysicalEntityOf;
    }

    private void checkAndAddFeature(EntityFeature feature, Set<PhysicalEntity> target) {
        if ((feature.getFeatureOf().contains(this) || feature.getNotFeatureOf().contains(this)) && this.log.isWarnEnabled()) {
            this.log.warn((Object)("Redundant attempt to set the inverse link!  this " + this.getModelInterface().getSimpleName() + " " + this.getRDFId() + " and - " + feature.getModelInterface().getSimpleName() + " " + feature.getRDFId()));
        }
        target.add(this);
    }

    private void checkAndRemoveFeature(EntityFeature feature, Set<PhysicalEntity> target) {
        assert (feature.getFeatureOf().contains(this) ^ feature.getNotFeatureOf().contains(this));
        target.remove(this);
    }

    @Override
    protected boolean semanticallyEquivalent(BioPAXElement element) {
        if (!(element instanceof PhysicalEntity)) {
            return false;
        }
        PhysicalEntity that = (PhysicalEntity)element;
        return this.hasEquivalentCellularLocation(that) && this.hasEquivalentFeatures(that) && SetEquivalenceChecker.isEquivalent(this.getMemberPhysicalEntity(), that.getMemberPhysicalEntity()) && super.semanticallyEquivalent(element);
    }

    @Override
    public int equivalenceCode() {
        return this.hashCode();
    }

    @Override
    public boolean hasEquivalentCellularLocation(PhysicalEntity that) {
        boolean equivalency = false;
        if (that != null) {
            equivalency = this.cellularLocation != null ? this.cellularLocation.isEquivalent(that.getCellularLocation()) : that.getCellularLocation() == null;
        }
        return equivalency;
    }

    @Override
    public boolean hasEquivalentFeatures(PhysicalEntity that) {
        boolean equivalency = false;
        if (that != null) {
            equivalency = SetEquivalenceChecker.isEquivalent(this.getFeature(), that.getFeature()) && SetEquivalenceChecker.isEquivalent(this.getNotFeature(), that.getNotFeature());
        }
        return equivalency;
    }

    protected int locationAndFeatureCode() {
        int result = this.cellularLocation != null ? this.cellularLocation.hashCode() : 0;
        result = 31 * result + (this.feature != null ? ((Object)this.feature).hashCode() : 0);
        result = 31 * result + (this.notFeature != null ? ((Object)this.notFeature).hashCode() : 0);
        return result;
    }

    @Override
    @ManyToMany(targetEntity=ControlImpl.class, mappedBy="peController")
    public Set<Control> getControllerOf() {
        return this.controllerOf;
    }

    protected void setControllerOf(Set<Control> controllerOf) {
        this.controllerOf = controllerOf;
    }

    protected void setMemberPhysicalEntityOf(Set<PhysicalEntity> memberPhysicalEntityOf) {
        this.memberPhysicalEntityOf = memberPhysicalEntityOf;
    }

    protected void setComponentOf(Set<Complex> componentOf) {
        this.componentOf = componentOf;
    }
}

