/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.impl.level3;

import java.util.Set;
import javax.persistence.Entity;
import javax.persistence.Enumerated;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import org.biopax.paxtools.impl.level3.InteractionImpl;
import org.biopax.paxtools.impl.level3.NucleicAcidImpl;
import org.biopax.paxtools.impl.level3.PhysicalEntityImpl;
import org.biopax.paxtools.model.level3.NucleicAcid;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.TemplateDirectionType;
import org.biopax.paxtools.model.level3.TemplateReaction;
import org.biopax.paxtools.util.BiopaxSafeSet;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;
import org.hibernate.search.annotations.Indexed;

@Entity
@Proxy(proxyClass=TemplateReaction.class)
@Indexed
@DynamicUpdate
@DynamicInsert
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class TemplateReactionImpl
extends InteractionImpl
implements TemplateReaction {
    private Set<PhysicalEntity> product = new BiopaxSafeSet<PhysicalEntity>();
    private NucleicAcid template;
    private TemplateDirectionType templateDirection;

    @Transient
    public Class<? extends TemplateReaction> getModelInterface() {
        return TemplateReaction.class;
    }

    @Override
    @Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
    @ManyToMany(targetEntity=PhysicalEntityImpl.class)
    @JoinTable(name="product")
    public Set<PhysicalEntity> getProduct() {
        return this.product;
    }

    protected void setProduct(Set<PhysicalEntity> product) {
        this.product = product;
    }

    @Override
    public void addProduct(PhysicalEntity product) {
        if (product != null) {
            this.product.add(product);
            super.addParticipant(product);
        }
    }

    @Override
    public void removeProduct(PhysicalEntity product) {
        if (product != null) {
            super.removeParticipant(product);
            this.product.remove(product);
        }
    }

    @ManyToOne(targetEntity=NucleicAcidImpl.class)
    protected NucleicAcid getTemplateX() {
        return this.template;
    }

    protected void setTemplateX(NucleicAcid template) {
        this.template = template;
    }

    @Override
    @Transient
    public NucleicAcid getTemplate() {
        return this.template;
    }

    @Override
    public void setTemplate(NucleicAcid template) {
        if (this.template != null) {
            super.removeParticipant(this.template);
        }
        if (template != null) {
            this.template = template;
            super.addParticipant(template);
        }
    }

    @Override
    @Enumerated
    public TemplateDirectionType getTemplateDirection() {
        return this.templateDirection;
    }

    @Override
    public void setTemplateDirection(TemplateDirectionType templateDirection) {
        this.templateDirection = templateDirection;
    }
}

