/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.model;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.impl.BioPAXElementImpl;
import org.biopax.paxtools.impl.ModelImpl;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;

public abstract class BioPAXFactory {
    private static final Log log = LogFactory.getLog(BioPAXFactory.class);
    private final Method setUriMethod;

    protected BioPAXFactory() {
        try {
            this.setUriMethod = BioPAXElementImpl.class.getDeclaredMethod("setRDFId", String.class);
            this.setUriMethod.setAccessible(true);
        }
        catch (Throwable e) {
            throw new RuntimeException("BioPAXFactory Constructor failed", e);
        }
    }

    public abstract BioPAXLevel getLevel();

    public BioPAXElement create(String localName, String uri) {
        Class<? extends BioPAXElement> type = this.getLevel().getInterfaceForName(localName);
        return this.create(type, uri);
    }

    public <T extends BioPAXElement> T create(Class<T> aClass, String uri) {
        BioPAXElement bpe = null;
        try {
            Class<T> t = this.getImplClass(aClass);
            if (t == null) {
                log.error((Object)("Could not find a class implementing " + aClass));
                return null;
            }
            Constructor<T> c = t.getDeclaredConstructor(new Class[0]);
            c.setAccessible(true);
            bpe = (BioPAXElement)c.newInstance(new Object[0]);
            this.setUriMethod.invoke((Object)bpe, uri);
        }
        catch (Exception e) {
            log.error((Object)("Could not instantiate BioPAX Type: " + aClass + "; URI: " + uri), (Throwable)e);
        }
        return (T)bpe;
    }

    public abstract String mapClassName(Class<? extends BioPAXElement> var1);

    public boolean canInstantiate(Class<? extends BioPAXElement> aClass) {
        try {
            String cname = this.mapClassName(aClass);
            return !Modifier.isAbstract(Class.forName(cname).getModifiers());
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (Exception ex) {
            log.error((Object)("Error in canInstantiate(" + aClass + ")"), (Throwable)ex);
            return false;
        }
    }

    public Model createModel() {
        return new ModelImpl(this);
    }

    public <T extends BioPAXElement> Class<T> getImplClass(Class<T> aModelInterfaceClass) {
        Class<?> implClass = null;
        if (aModelInterfaceClass.isInterface()) {
            String name = this.mapClassName(aModelInterfaceClass);
            try {
                implClass = Class.forName(name);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        return implClass;
    }
}

