/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.util;

import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.model.BioPAXElement;

public class BiopaxSafeSet<E extends BioPAXElement>
extends AbstractSet<E> {
    private static final Log LOG = LogFactory.getLog(BiopaxSafeSet.class);
    private final Map<String, E> map = new HashMap<String, E>();

    @Override
    public Iterator<E> iterator() {
        return this.map.values().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean add(E bpe) {
        String uri = bpe.getRDFId();
        if (!this.map.containsKey(uri)) {
            this.map.put(uri, bpe);
            return true;
        }
        LOG.debug((Object)("ignored duplicate:" + bpe.getRDFId()));
        return false;
    }

    @Override
    public boolean contains(Object o) {
        return super.contains(o) && this.get(((BioPAXElement)o).getRDFId()) == o;
    }

    public E get(String uri) {
        return (E)((BioPAXElement)this.map.get(uri));
    }
}

