/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.Named;
import org.biopax.paxtools.pattern.Match;
import org.biopax.paxtools.pattern.Pattern;
import org.biopax.paxtools.pattern.PatternBox;
import org.biopax.paxtools.pattern.Searcher;
import org.biopax.paxtools.pattern.c.ConBox;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PatternBoxTest {
    Model model;
    Model model_urea;

    @Before
    public void setUp() throws Exception {
        SimpleIOHandler h = new SimpleIOHandler();
        this.model = h.convertFromOWL(this.getClass().getResourceAsStream("AR-TP53.owl"));
        this.model_urea = h.convertFromOWL(this.getClass().getResourceAsStream("UreaCycle.owl"));
    }

    @Test
    public void testInSameComplex() throws Exception {
        List list = Searcher.search((BioPAXElement)this.model.getByID("http://pid.nci.nih.gov/biopaxpid_33442"), (Pattern)PatternBox.inSameComplex());
        Assert.assertTrue((list.size() == 1 ? 1 : 0) != 0);
        Map map = Searcher.search((Model)this.model, (Pattern)PatternBox.inSameComplex());
        for (BioPAXElement ele : map.keySet()) {
        }
    }

    @Test
    public void testControlsStateChange() throws Exception {
        Map map = Searcher.search((Model)this.model, (Pattern)PatternBox.controlsStateChange((boolean)false));
        Assert.assertTrue((map.size() > 0 ? 1 : 0) != 0);
        for (BioPAXElement ele : map.keySet()) {
        }
        map = Searcher.search((Model)this.model, (Pattern)PatternBox.controlsStateChange((boolean)true));
        Assert.assertTrue((map.size() > 0 ? 1 : 0) != 0);
        for (BioPAXElement bioPAXElement : map.keySet()) {
        }
    }

    @Test
    public void testConsecutiveCatalysis() throws Exception {
        Pattern p = PatternBox.consecutiveCatalysis(null);
        p.insertPointConstraint(ConBox.notUbique(Collections.singleton("http://www.reactome.org/biopax/68322SmallMolecule19")), new int[]{5});
        Map map = Searcher.search((Model)this.model_urea, (Pattern)p);
        Assert.assertTrue((map.size() > 0 ? 1 : 0) != 0);
        for (BioPAXElement ele : map.keySet()) {
            this.printMatches((Collection)map.get(ele), 0, 5, 10);
        }
    }

    protected void printMatches(Collection<Match> matches) {
        if (matches.isEmpty()) {
            return;
        }
        this.printMatches(matches, 0, matches.iterator().next().varSize() - 1);
    }

    protected void printMatches(Collection<Match> matches, int ... ind) {
        for (Match match : matches) {
            System.out.print(this.name(match.get(ind[0])));
            for (int i = 1; i < ind.length; ++i) {
                System.out.print(" --- " + this.name(match.get(ind[i])));
            }
            System.out.println();
        }
    }

    protected String name(BioPAXElement ele) {
        if (ele instanceof Named) {
            return ((Named)ele).getDisplayName();
        }
        return ele.getRDFId();
    }
}

