/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.c;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.pattern.MappedConst;
import org.biopax.paxtools.pattern.Match;
import org.biopax.paxtools.pattern.Pattern;
import org.biopax.paxtools.pattern.Searcher;
import org.biopax.paxtools.pattern.c.ConBox;
import org.biopax.paxtools.pattern.c.TestParent;
import org.junit.Assert;
import org.junit.Test;

public class ConBoxTest
extends TestParent {
    @Test
    public void testErToPE() throws Exception {
        List list = Searcher.search((BioPAXElement)this.model.getByID("urn:miriam:uniprot:P04637"), (Pattern)new Pattern(2, EntityReference.class, Collections.singletonList(new MappedConst(ConBox.erToPE(), new int[]{0, 1}))));
        Assert.assertTrue((list.size() == 5 ? 1 : 0) != 0);
    }

    @Test
    public void testPeToER() throws Exception {
        List list = Searcher.search((BioPAXElement)this.model.getByID("http://pid.nci.nih.gov/biopaxpid_17220"), (Pattern)new Pattern(2, PhysicalEntity.class, Collections.singletonList(new MappedConst(ConBox.peToER(), new int[]{0, 1}))));
        Assert.assertTrue((list.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testDownControl() throws Exception {
        List list = Searcher.search((BioPAXElement)this.model.getByID("http://pid.nci.nih.gov/biopaxpid_35449"), (Pattern)new Pattern(2, PhysicalEntity.class, Collections.singletonList(new MappedConst(ConBox.peToControl(), new int[]{0, 1}))));
        Assert.assertTrue((list.size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testControlled() throws Exception {
        List list = Searcher.search((BioPAXElement)this.model.getByID("http://pid.nci.nih.gov/biopaxpid_35543"), (Pattern)new Pattern(2, Control.class, Collections.singletonList(new MappedConst(ConBox.controlled(), new int[]{0, 1}))));
        Assert.assertTrue((list.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((((Match)list.get(0)).get(1) == this.model.getByID("http://pid.nci.nih.gov/biopaxpid_35537") ? 1 : 0) != 0);
    }

    @Test
    public void testControlToConv() throws Exception {
        List list = Searcher.search((BioPAXElement)this.model.getByID("http://pid.nci.nih.gov/biopaxpid_35543"), (Pattern)new Pattern(2, Control.class, Collections.singletonList(new MappedConst(ConBox.controlToConv(), new int[]{0, 1}))));
        Assert.assertTrue((list.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((((Match)list.get(0)).get(1) == this.model.getByID("http://pid.nci.nih.gov/biopaxpid_35537") ? 1 : 0) != 0);
    }

    @Test
    public void testControlsConv() throws Exception {
        List list = Searcher.search((BioPAXElement)this.model.getByID("http://pid.nci.nih.gov/biopaxpid_35449"), (Pattern)new Pattern(2, PhysicalEntity.class, Collections.singletonList(new MappedConst(ConBox.controlsConv(), new int[]{0, 1}))));
        Assert.assertTrue((list.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((((Match)list.get(0)).get(1) == this.model.getByID("http://pid.nci.nih.gov/biopaxpid_35537") ? 1 : 0) != 0);
    }

    @Test
    public void testGenericEquiv() throws Exception {
        List list = Searcher.search((BioPAXElement)this.model.getByID("http://pid.nci.nih.gov/biopaxpid_637"), (Pattern)new Pattern(2, PhysicalEntity.class, Collections.singletonList(new MappedConst(ConBox.genericEquiv(), new int[]{0, 1}))));
        Assert.assertTrue((list.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.collect(list, 1).contains(this.model.getByID("http://pid.nci.nih.gov/biopaxpid_623")));
        list = Searcher.search((BioPAXElement)this.model.getByID("http://pid.nci.nih.gov/biopaxpid_623"), (Pattern)new Pattern(2, PhysicalEntity.class, Collections.singletonList(new MappedConst(ConBox.genericEquiv(), new int[]{0, 1}))));
        Assert.assertTrue((list.size() == 7 ? 1 : 0) != 0);
    }

    @Test
    public void testComplexMembers() throws Exception {
        List list = Searcher.search((BioPAXElement)this.model.getByID("http://pid.nci.nih.gov/biopaxpid_35409"), (Pattern)new Pattern(2, Complex.class, Collections.singletonList(new MappedConst(ConBox.complexMembers(), new int[]{0, 1}))));
        Assert.assertTrue((list.size() == 4 ? 1 : 0) != 0);
    }

    @Test
    public void testSimpleMembers() throws Exception {
        List list = Searcher.search((BioPAXElement)this.model.getByID("http://pid.nci.nih.gov/biopaxpid_35409"), (Pattern)new Pattern(2, Complex.class, Collections.singletonList(new MappedConst(ConBox.simpleMembers(), new int[]{0, 1}))));
        Assert.assertTrue((list.size() == 4 ? 1 : 0) != 0);
    }

    @Test
    public void testWithComplexMembers() throws Exception {
        List list = Searcher.search((BioPAXElement)this.model.getByID("http://pid.nci.nih.gov/biopaxpid_35409"), (Pattern)new Pattern(2, PhysicalEntity.class, Collections.singletonList(new MappedConst(ConBox.withComplexMembers(), new int[]{0, 1}))));
        Assert.assertTrue((list.size() == 5 ? 1 : 0) != 0);
    }

    @Test
    public void testWithSimpleMembers() throws Exception {
        List list = Searcher.search((BioPAXElement)this.model.getByID("http://pid.nci.nih.gov/biopaxpid_35409"), (Pattern)new Pattern(2, PhysicalEntity.class, Collections.singletonList(new MappedConst(ConBox.withSimpleMembers(), new int[]{0, 1}))));
        Assert.assertTrue((list.size() == 5 ? 1 : 0) != 0);
    }

    @Test
    public void testComplexes() throws Exception {
        List list = Searcher.search((BioPAXElement)this.model.getByID("http://pid.nci.nih.gov/biopaxpid_5511"), (Pattern)new Pattern(2, PhysicalEntity.class, Collections.singletonList(new MappedConst(ConBox.complexes(), new int[]{0, 1}))));
        Assert.assertTrue((list.size() == 2 ? 1 : 0) != 0);
    }

    @Test
    public void testWithComplexes() throws Exception {
        List list = Searcher.search((BioPAXElement)this.model.getByID("http://pid.nci.nih.gov/biopaxpid_5511"), (Pattern)new Pattern(2, PhysicalEntity.class, Collections.singletonList(new MappedConst(ConBox.withComplexes(), new int[]{0, 1}))));
        Assert.assertTrue((list.size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testLeft() throws Exception {
        List list = Searcher.search((BioPAXElement)this.model.getByID("http://pid.nci.nih.gov/biopaxpid_35537"), (Pattern)new Pattern(2, Conversion.class, Collections.singletonList(new MappedConst(ConBox.left(), new int[]{0, 1}))));
        Assert.assertTrue((list.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.collect(list, 1).contains(this.model.getByID("http://pid.nci.nih.gov/biopaxpid_685")));
        Assert.assertTrue((boolean)this.collect(list, 1).contains(this.model.getByID("http://pid.nci.nih.gov/biopaxpid_35409")));
    }

    @Test
    public void testRight() throws Exception {
        List list = Searcher.search((BioPAXElement)this.model.getByID("http://pid.nci.nih.gov/biopaxpid_35537"), (Pattern)new Pattern(2, Conversion.class, Collections.singletonList(new MappedConst(ConBox.right(), new int[]{0, 1}))));
        Assert.assertTrue((list.size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.collect(list, 1).contains(this.model.getByID("http://pid.nci.nih.gov/biopaxpid_678")));
        Assert.assertTrue((boolean)this.collect(list, 1).contains(this.model.getByID("http://pid.nci.nih.gov/biopaxpid_21741")));
        Assert.assertTrue((boolean)this.collect(list, 1).contains(this.model.getByID("http://pid.nci.nih.gov/biopaxpid_31826")));
    }

    @Test
    public void testParticipatesInConv() throws Exception {
        List list = Searcher.search((BioPAXElement)this.model.getByID("http://pid.nci.nih.gov/biopaxpid_31826"), (Pattern)new Pattern(2, PhysicalEntity.class, Collections.singletonList(new MappedConst(ConBox.participatesInConv(), new int[]{0, 1}))));
        Assert.assertTrue((list.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.collect(list, 1).contains(this.model.getByID("http://pid.nci.nih.gov/biopaxpid_35537")));
    }

    @Test
    public void testNameEquals() throws Exception {
        List list = Searcher.search((BioPAXElement)this.model.getByID("http://pid.nci.nih.gov/biopaxpid_35409"), (Pattern)new Pattern(2, Complex.class, Arrays.asList(new MappedConst(ConBox.complexMembers(), new int[]{0, 1}), new MappedConst(ConBox.nameEquals((String)"GDP"), new int[]{1}))));
        Assert.assertTrue((list.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.collect(list, 1).contains(this.model.getByID("http://pid.nci.nih.gov/biopaxpid_678")));
    }

    @Test
    public void testNotUbique() throws Exception {
        List list = Searcher.search((BioPAXElement)this.model.getByID("http://pid.nci.nih.gov/biopaxpid_35409"), (Pattern)new Pattern(2, Complex.class, Arrays.asList(new MappedConst(ConBox.complexMembers(), new int[]{0, 1}), new MappedConst(ConBox.notUbique(Collections.singleton("http://pid.nci.nih.gov/biopaxpid_678")), new int[]{1}))));
        Assert.assertTrue((list.size() == 3 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)this.collect(list, 1).contains(this.model.getByID("http://pid.nci.nih.gov/biopaxpid_678")));
    }
}

