/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.pattern.c;

import java.util.List;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.paxtools.model.level3.SmallMolecule;
import org.biopax.paxtools.pattern.Constraint;
import org.biopax.paxtools.pattern.MappedConst;
import org.biopax.paxtools.pattern.Match;
import org.biopax.paxtools.pattern.Pattern;
import org.biopax.paxtools.pattern.Searcher;
import org.biopax.paxtools.pattern.c.AND;
import org.biopax.paxtools.pattern.c.ConBox;
import org.biopax.paxtools.pattern.c.Equality;
import org.biopax.paxtools.pattern.c.MultiPathConstraint;
import org.biopax.paxtools.pattern.c.NOT;
import org.biopax.paxtools.pattern.c.OtherSide;
import org.biopax.paxtools.pattern.c.ParticipatesInConv;
import org.biopax.paxtools.pattern.c.PathConstraint;
import org.biopax.paxtools.pattern.c.RelType;
import org.biopax.paxtools.pattern.c.SelfOrThis;
import org.biopax.paxtools.pattern.c.TestParent;
import org.biopax.paxtools.pattern.c.Type;
import org.junit.Assert;
import org.junit.Test;

public class ConstraintTest
extends TestParent {
    @Test
    public void testAND() throws Exception {
        Pattern p = new Pattern(2, PhysicalEntity.class);
        p.addConstraint((Constraint)new AND(new MappedConst[]{new MappedConst(ConBox.withComplexMembers(), new int[]{0, 1}), new MappedConst((Constraint)new PathConstraint("PhysicalEntity/participantOf/right/entityReference/entityReferenceOf"), new int[]{0, 1})}), new int[]{0, 1});
        List list = Searcher.search((BioPAXElement)this.model.getByID("http://pid.nci.nih.gov/biopaxpid_35409"), (Pattern)p);
        Assert.assertTrue((list.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((((Match)list.get(0)).get(1) == this.model.getByID("http://pid.nci.nih.gov/biopaxpid_678") ? 1 : 0) != 0);
    }

    @Test
    public void testType() throws Exception {
        Pattern p = new Pattern(2, Complex.class);
        p.addConstraint(ConBox.complexMembers(), new int[]{0, 1});
        p.addConstraint((Constraint)new Type(SmallMolecule.class), new int[]{1});
        List list = Searcher.search((BioPAXElement)this.model.getByID("http://pid.nci.nih.gov/biopaxpid_35409"), (Pattern)p);
        Assert.assertTrue((list.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((((Match)list.get(0)).get(1) == this.model.getByID("http://pid.nci.nih.gov/biopaxpid_678") ? 1 : 0) != 0);
        p = new Pattern(2, Complex.class);
        p.addConstraint(ConBox.complexMembers(), new int[]{0, 1});
        p.addConstraint((Constraint)new Type(SimplePhysicalEntity.class), new int[]{1});
        list = Searcher.search((BioPAXElement)this.model.getByID("http://pid.nci.nih.gov/biopaxpid_35409"), (Pattern)p);
        Assert.assertTrue((list.size() == 4 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.collect(list, 1).contains(this.model.getByID("http://pid.nci.nih.gov/biopaxpid_678")));
    }

    @Test
    public void testEquality() throws Exception {
        Pattern p = new Pattern(5, PhysicalEntity.class);
        p.addConstraint(ConBox.genericEquiv(), new int[]{0, 1});
        p.addConstraint(ConBox.genericEquiv(), new int[]{0, 2});
        p.addConstraint((Constraint)new Equality(false), new int[]{1, 2});
        p.addConstraint(ConBox.peToER(), new int[]{1, 3});
        p.addConstraint(ConBox.peToER(), new int[]{2, 4});
        p.addConstraint((Constraint)new Equality(true), new int[]{3, 4});
        List list = Searcher.search((BioPAXElement)this.model.getByID("http://pid.nci.nih.gov/biopaxpid_623"), (Pattern)p);
        Assert.assertTrue((list.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.collect(list, 1).contains(this.model.getByID("http://pid.nci.nih.gov/biopaxpid_637")));
        Assert.assertTrue((boolean)this.collect(list, 1).contains(this.model.getByID("http://pid.nci.nih.gov/biopaxpid_638")));
    }

    @Test
    public void testNOT() throws Exception {
        Pattern p = new Pattern(2, Complex.class);
        p.addConstraint(ConBox.complexMembers(), new int[]{0, 1});
        p.addConstraint((Constraint)new NOT((Constraint)new Type(SmallMolecule.class)), new int[]{1});
        List list = Searcher.search((BioPAXElement)this.model.getByID("http://pid.nci.nih.gov/biopaxpid_35409"), (Pattern)p);
        Assert.assertTrue((list.size() == 3 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)this.collect(list, 1).contains(this.model.getByID("http://pid.nci.nih.gov/biopaxpid_678")));
    }

    @Test
    public void testMultiPath() throws Exception {
        Pattern p = new Pattern(2, PhysicalEntity.class);
        p.addConstraint((Constraint)new MultiPathConstraint(new String[]{"PhysicalEntity/controllerOf/controlled", "PhysicalEntity/participantOf:Conversion"}), new int[]{0, 1});
        List list = Searcher.search((BioPAXElement)this.model.getByID("http://pid.nci.nih.gov/biopaxpid_21741"), (Pattern)p);
        Assert.assertTrue((list.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.collect(list, 1).contains(this.model.getByID("http://pid.nci.nih.gov/biopaxpid_50156")));
        Assert.assertTrue((boolean)this.collect(list, 1).contains(this.model.getByID("http://pid.nci.nih.gov/biopaxpid_35537")));
    }

    @Test
    public void testOtherSide() throws Exception {
        Pattern p = new Pattern(3, PhysicalEntity.class);
        p.addConstraint(ConBox.participatesInConv(), new int[]{0, 1});
        p.addConstraint((Constraint)new OtherSide(), new int[]{0, 1, 2});
        List list = Searcher.search((BioPAXElement)this.model.getByID("http://pid.nci.nih.gov/biopaxpid_21151"), (Pattern)p);
        Assert.assertTrue((list.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.collect(list, 1).contains(this.model.getByID("http://pid.nci.nih.gov/biopaxpid_50156")));
        Assert.assertTrue((boolean)this.collect(list, 2).contains(this.model.getByID("http://pid.nci.nih.gov/biopaxpid_17089")));
    }

    @Test
    public void testParticipatesInConv() throws Exception {
        Pattern p = new Pattern(2, PhysicalEntity.class);
        p.addConstraint((Constraint)new ParticipatesInConv(RelType.INPUT, false), new int[]{0, 1});
        List list = Searcher.search((BioPAXElement)this.model.getByID("http://pid.nci.nih.gov/biopaxpid_21151"), (Pattern)p);
        Assert.assertTrue((list.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.collect(list, 1).contains(this.model.getByID("http://pid.nci.nih.gov/biopaxpid_50156")));
        p = new Pattern(2, PhysicalEntity.class);
        p.addConstraint((Constraint)new ParticipatesInConv(RelType.OUTPUT, false), new int[]{0, 1});
        list = Searcher.search((BioPAXElement)this.model.getByID("http://pid.nci.nih.gov/biopaxpid_21151"), (Pattern)p);
        Assert.assertTrue((boolean)list.isEmpty());
    }

    @Test
    public void testSelfOrThis() throws Exception {
        Pattern p = new Pattern(2, PhysicalEntity.class);
        p.addConstraint((Constraint)new SelfOrThis((Constraint)new ParticipatesInConv(RelType.INPUT, false)), new int[]{0, 1});
        List list = Searcher.search((BioPAXElement)this.model.getByID("http://pid.nci.nih.gov/biopaxpid_21151"), (Pattern)p);
        Assert.assertTrue((list.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.collect(list, 1).contains(this.model.getByID("http://pid.nci.nih.gov/biopaxpid_50156")));
        Assert.assertTrue((boolean)this.collect(list, 1).contains(this.model.getByID("http://pid.nci.nih.gov/biopaxpid_21151")));
    }
}

