/*
 * Decompiled with CFR 0.152.
 */
package org.paxtools.query;

import java.io.FileOutputStream;
import java.io.OutputStream;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXFactory;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.BiochemicalReaction;
import org.biopax.paxtools.model.level3.Catalysis;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.ComplexAssembly;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.ControlType;
import org.biopax.paxtools.model.level3.Controller;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.ConversionDirectionType;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Process;
import org.biopax.paxtools.model.level3.Protein;
import org.biopax.paxtools.model.level3.ProteinReference;

public class ModelBuilder {
    static final String IDBASE = "";
    static final BioPAXFactory factory = BioPAXLevel.L3.getDefaultFactory();
    static final String REACTION_ARROW = "_->_";
    static final String ACTIV_ARROW = "_activates_";
    static final String DIR = "../biopax/Level3/examples/";

    public void generateModel1() throws Throwable {
        Model model = factory.createModel();
        ModelBuilder.createStateChange("Z", model);
        Conversion last = (Conversion)model.getByID("Z-1_->_Z-2");
        ModelBuilder.createStateChange("A", model);
        ModelBuilder.createCascadeBetween((Protein)model.getByID("A-1"), last, "B", 5, model);
        ModelBuilder.createCascadeBetween((Protein)model.getByID("A-2"), last, "C", 5, model);
        ModelBuilder.createStateChange("D", model);
        ModelBuilder.createStateChange("E", model);
        ModelBuilder.createComplex(model, "Comp1", (Protein)model.getByID("D-2"), (Protein)model.getByID("E-2"));
        ModelBuilder.createControl((Protein)model.getByID("D-2_cm"), (Conversion)model.getByID("A-1_->_A-2"), Catalysis.class, ControlType.INHIBITION, model);
        SimpleIOHandler io = new SimpleIOHandler();
        io.convertToOWL(model, (OutputStream)new FileOutputStream("../biopax/Level3/examples/temp2.owl"));
    }

    public static void createStateChange(String name, Model model) {
        String stdName = name + "_PR";
        ProteinReference ref = (ProteinReference)model.addNew(ProteinReference.class, IDBASE + stdName);
        ref.setStandardName(stdName);
        stdName = name + "-1";
        Protein p1 = (Protein)model.addNew(Protein.class, IDBASE + stdName);
        p1.setEntityReference((EntityReference)ref);
        p1.setStandardName(stdName);
        stdName = name + "-2";
        Protein p2 = (Protein)model.addNew(Protein.class, IDBASE + stdName);
        p2.setEntityReference((EntityReference)ref);
        p2.setStandardName(stdName);
        stdName = p1.getStandardName() + REACTION_ARROW + p2.getStandardName();
        BiochemicalReaction reac = (BiochemicalReaction)model.addNew(BiochemicalReaction.class, IDBASE + stdName);
        reac.setStandardName(stdName);
        reac.addLeft((PhysicalEntity)p1);
        reac.addRight((PhysicalEntity)p2);
        reac.setConversionDirection(ConversionDirectionType.LEFT_TO_RIGHT);
    }

    public static void createActivatedStateChange(Protein activator, String name, Model model) {
        ModelBuilder.createStateChange(name, model);
        BiochemicalReaction reac = (BiochemicalReaction)model.getByID(IDBASE + name + "-1" + REACTION_ARROW + name + "-2");
        ModelBuilder.createControl(activator, (Conversion)reac, Catalysis.class, ControlType.ACTIVATION, model);
    }

    public static void createControl(Protein effector, Conversion conv, Class<? extends Control> cls, ControlType type, Model model) {
        String std = effector.getStandardName() + ACTIV_ARROW + conv.getStandardName();
        Control con = (Control)factory.create(cls, IDBASE + std);
        con.setStandardName(std);
        con.addController((Controller)effector);
        con.addControlled((Process)conv);
        con.setControlType(type);
        model.add((BioPAXElement)con);
    }

    public static void createCascadeBetween(Protein first, Conversion last, String name, int length, Model model) {
        ModelBuilder.createActivatedStateChange(first, name + 1, model);
        for (int i = 2; i <= length; ++i) {
            Protein act = (Protein)model.getByID(IDBASE + name + (i - 1) + "-2");
            ModelBuilder.createActivatedStateChange(act, name + i, model);
        }
        Protein act = (Protein)model.getByID(IDBASE + name + length + "-2");
        ModelBuilder.createControl(act, last, Catalysis.class, ControlType.ACTIVATION, model);
    }

    public static void createComplex(Model model, String compName, Protein ... prots) {
        Complex comp = (Complex)model.addNew(Complex.class, IDBASE + compName);
        comp.setStandardName(compName);
        for (Protein prot : prots) {
            String std = prot.getStandardName() + "_cm";
            Protein p = (Protein)model.addNew(Protein.class, IDBASE + std);
            p.setStandardName(std);
            comp.addComponent((PhysicalEntity)p);
        }
        String std = "Assembly_of_" + compName;
        ComplexAssembly ca = (ComplexAssembly)model.addNew(ComplexAssembly.class, IDBASE + std);
        ca.setStandardName(std);
        ca.setConversionDirection(ConversionDirectionType.LEFT_TO_RIGHT);
        for (Protein prot : prots) {
            ca.addLeft((PhysicalEntity)prot);
        }
        ca.addRight((PhysicalEntity)comp);
    }
}

