/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.query.algorithm;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.query.algorithm.Direction;
import org.biopax.paxtools.query.model.Edge;
import org.biopax.paxtools.query.model.GraphObject;
import org.biopax.paxtools.query.model.Node;

public class BFS {
    protected Map<GraphObject, Integer> dist;
    protected Map<GraphObject, Integer> colors;
    protected Set<Node> sourceSet;
    protected Set<Node> stopSet;
    protected Direction direction;
    protected int limit;
    protected LinkedList<Node> queue;
    public static final boolean FORWARD = true;
    public static final boolean BACKWARD = false;
    public static final boolean UPWARD = true;
    public static final boolean DOWNWARD = false;
    public static final int WHITE = 0;
    public static final int GRAY = 1;
    public static final int BLACK = 2;

    public BFS(Set<Node> sourceSet, Set<Node> stopSet, Direction direction, int limit) {
        if (direction == Direction.BOTHSTREAM) {
            throw new IllegalArgumentException("BOTHSTREAM is not a valid parameter in BFS");
        }
        this.sourceSet = sourceSet;
        this.stopSet = stopSet;
        this.direction = direction;
        this.limit = limit;
    }

    public BFS() {
    }

    public Map<GraphObject, Integer> run() {
        return this.runBFS();
    }

    public Map<GraphObject, Integer> runBFS() {
        this.initMaps();
        if (this.limit > 0) {
            this.queue.addAll(this.sourceSet);
        }
        for (Node source : this.sourceSet) {
            this.setLabel(source, 0);
            this.setColor(source, 1);
            this.labelEquivRecursive(source, true, 0, true, false);
            this.labelEquivRecursive(source, false, 0, true, false);
        }
        while (!this.queue.isEmpty()) {
            Node current = this.queue.remove(0);
            this.processNode(current);
            this.setColor(current, 2);
        }
        return this.dist;
    }

    protected void initMaps() {
        this.dist = new HashMap<GraphObject, Integer>();
        this.colors = new HashMap<GraphObject, Integer>();
        this.queue = new LinkedList();
    }

    protected void processNode(Node current) {
        if (current.isUbique()) {
            this.setColor(current, 2);
            return;
        }
        for (Edge edge : this.direction == Direction.DOWNSTREAM ? current.getDownstream() : current.getUpstream()) {
            boolean further;
            Node neigh;
            assert (edge != null);
            if (this.direction == Direction.DOWNSTREAM || !current.isBreadthNode()) {
                this.setLabel(edge, this.getLabel(current));
            } else {
                this.setLabel(edge, this.getLabel(current) + 1);
            }
            Node node = neigh = this.direction == Direction.DOWNSTREAM ? edge.getTargetNode() : edge.getSourceNode();
            assert (neigh != null);
            int dist = this.getLabel(edge);
            if (neigh.isBreadthNode() && this.direction == Direction.DOWNSTREAM) {
                ++dist;
            }
            boolean bl = further = !(this.stopSet != null && this.isEquivalentInTheSet(neigh, this.stopSet) || neigh.isBreadthNode() && dist >= this.limit || neigh.isUbique());
            if (this.getColor(neigh) == 0) {
                this.setLabel(neigh, dist);
                if (further) {
                    this.setColor(neigh, 1);
                    if (neigh.isBreadthNode()) {
                        this.queue.addLast(neigh);
                    } else {
                        this.queue.addFirst(neigh);
                    }
                } else {
                    this.setColor(neigh, 2);
                }
            }
            this.labelEquivRecursive(neigh, true, this.getLabel(neigh), further, !neigh.isBreadthNode());
            this.labelEquivRecursive(neigh, false, this.getLabel(neigh), further, !neigh.isBreadthNode());
        }
    }

    protected void labelEquivRecursive(Node node, boolean up, int dist, boolean enqueue, boolean head) {
        for (Node equiv : up ? node.getUpperEquivalent() : node.getLowerEquivalent()) {
            if (this.getColor(equiv) == 0) {
                this.setLabel(equiv, dist);
                if (enqueue) {
                    this.setColor(equiv, 1);
                    if (head) {
                        this.queue.addFirst(equiv);
                    } else {
                        this.queue.add(equiv);
                    }
                } else {
                    this.setColor(equiv, 2);
                }
            }
            this.labelEquivRecursive(equiv, up, dist, enqueue, head);
        }
    }

    protected boolean isEquivalentInTheSet(Node node, Set<Node> set) {
        return set.contains(node) || this.isEquivalentInTheSet(node, true, set) || this.isEquivalentInTheSet(node, false, set);
    }

    protected boolean isEquivalentInTheSet(Node node, boolean direction, Set<Node> set) {
        for (Node eq : direction ? node.getUpperEquivalent() : node.getLowerEquivalent()) {
            if (set.contains(eq)) {
                return true;
            }
            boolean isIn = this.isEquivalentInTheSet(eq, direction, set);
            if (!isIn) continue;
            return true;
        }
        return false;
    }

    protected int getColor(Node node) {
        if (!this.colors.containsKey(node)) {
            return 0;
        }
        return this.colors.get(node);
    }

    protected void setColor(Node node, int color) {
        this.colors.put(node, color);
    }

    public int getLabel(GraphObject go) {
        if (!this.dist.containsKey(go)) {
            return Integer.MAX_VALUE - this.limit * 2;
        }
        return this.dist.get(go);
    }

    protected void setLabel(GraphObject go, int label) {
        this.dist.put(go, label);
    }
}

