/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.query.algorithm;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.query.algorithm.BFS;
import org.biopax.paxtools.query.algorithm.Direction;
import org.biopax.paxtools.query.model.GraphObject;
import org.biopax.paxtools.query.model.Node;

public class NeighborhoodQuery {
    private Set<Node> sourceNodes;
    private Direction direction;
    private int limit;
    private Map<GraphObject, Integer> mapBackward;
    private Map<GraphObject, Integer> mapForward;

    public NeighborhoodQuery(Set<Node> sourceNodes, Direction direction, int limit) {
        this.sourceNodes = sourceNodes;
        this.direction = direction;
        this.limit = limit;
    }

    public Set<GraphObject> run() {
        HashSet<GraphObject> queryResult = new HashSet<GraphObject>();
        if (this.direction == Direction.UPSTREAM || this.direction == Direction.BOTHSTREAM) {
            BFS bfsBackward = new BFS(this.sourceNodes, null, Direction.UPSTREAM, this.limit);
            this.mapBackward = bfsBackward.run();
            queryResult.addAll(this.mapBackward.keySet());
        }
        if (this.direction == Direction.DOWNSTREAM || this.direction == Direction.BOTHSTREAM) {
            BFS bfsForward = new BFS(this.sourceNodes, null, Direction.DOWNSTREAM, this.limit);
            this.mapForward = bfsForward.run();
            queryResult.addAll(this.mapForward.keySet());
        }
        return queryResult;
    }
}

