/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.query.model;

import org.biopax.paxtools.query.model.Edge;
import org.biopax.paxtools.query.model.Graph;
import org.biopax.paxtools.query.model.Node;

public abstract class AbstractEdge
implements Edge {
    private Node source;
    private Node target;
    private Graph graph;

    public AbstractEdge(Node source, Node target, Graph graph) {
        this.source = source;
        this.target = target;
        this.graph = graph;
    }

    @Override
    public Node getTargetNode() {
        return this.target;
    }

    @Override
    public Node getSourceNode() {
        return this.source;
    }

    @Override
    public Graph getGraph() {
        return this.graph;
    }

    @Override
    public String getKey() {
        return this.source.getKey() + "|" + this.target.getKey();
    }

    public int hashCode() {
        return this.source.hashCode() + this.target.hashCode() + this.graph.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractEdge) {
            AbstractEdge e = (AbstractEdge)obj;
            return this.source == e.getSourceNode() && this.target == e.getTargetNode() && this.graph == e.getGraph();
        }
        return false;
    }

    @Override
    public int getSign() {
        return 1;
    }

    @Override
    public void clear() {
    }
}

