/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.query.wrapperL3;

import java.util.Collection;
import java.util.Collections;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.query.model.AbstractNode;
import org.biopax.paxtools.query.model.Graph;
import org.biopax.paxtools.query.model.Node;
import org.biopax.paxtools.query.wrapperL3.ControlWrapper;
import org.biopax.paxtools.query.wrapperL3.EdgeL3;
import org.biopax.paxtools.query.wrapperL3.GraphL3;

public abstract class EventWrapper
extends AbstractNode {
    protected EventWrapper(GraphL3 graph) {
        super(graph);
    }

    @Override
    public boolean isBreadthNode() {
        return false;
    }

    @Override
    public int getSign() {
        return 1;
    }

    @Override
    public boolean isUbique() {
        return false;
    }

    @Override
    public abstract boolean isTranscription();

    protected void addToUpstream(BioPAXElement ele, Graph graph) {
        AbstractNode node = (AbstractNode)graph.getGraphObject(ele);
        EdgeL3 edge = new EdgeL3(node, this, graph);
        if (this.isTranscription() && node instanceof ControlWrapper) {
            ((ControlWrapper)node).setTranscription(true);
        }
        node.getDownstreamNoInit().add(edge);
        this.getUpstreamNoInit().add(edge);
    }

    protected void addToDownstream(PhysicalEntity pe, Graph graph) {
        AbstractNode node = (AbstractNode)graph.getGraphObject(pe);
        EdgeL3 edge = new EdgeL3(this, node, graph);
        node.getUpstreamNoInit().add(edge);
        this.getDownstreamNoInit().add(edge);
    }

    @Override
    public Collection<Node> getUpperEquivalent() {
        return Collections.emptySet();
    }

    @Override
    public Collection<Node> getLowerEquivalent() {
        return Collections.emptySet();
    }
}

