/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.query.wrapperL3;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.TemplateReaction;
import org.biopax.paxtools.query.model.AbstractGraph;
import org.biopax.paxtools.query.model.GraphObject;
import org.biopax.paxtools.query.model.Node;
import org.biopax.paxtools.query.wrapperL3.ControlWrapper;
import org.biopax.paxtools.query.wrapperL3.ConversionWrapper;
import org.biopax.paxtools.query.wrapperL3.PhysicalEntityWrapper;
import org.biopax.paxtools.query.wrapperL3.TemplateReactionWrapper;

public class GraphL3
extends AbstractGraph {
    protected Model model;
    protected Set<String> ubiqueIDs;
    protected final Log log = LogFactory.getLog(GraphL3.class);

    public GraphL3(Model model, Set<String> ubiqueIDs) {
        assert (model.getLevel() == BioPAXLevel.L3);
        this.model = model;
        this.setUbiqueIDs(ubiqueIDs);
    }

    public void setUbiqueIDs(Set<String> ubiqueIDs) {
        this.ubiqueIDs = ubiqueIDs;
    }

    @Override
    public Node wrap(Object obj) {
        if (obj instanceof PhysicalEntity) {
            PhysicalEntity pe = (PhysicalEntity)obj;
            PhysicalEntityWrapper pew = new PhysicalEntityWrapper(pe, this);
            if (this.ubiqueIDs != null && this.ubiqueIDs.contains(pe.getRDFId())) {
                pew.setUbique(true);
            }
            return pew;
        }
        if (obj instanceof Conversion) {
            return new ConversionWrapper((Conversion)obj, this);
        }
        if (obj instanceof TemplateReaction) {
            return new TemplateReactionWrapper((TemplateReaction)obj, this);
        }
        if (obj instanceof Control) {
            return new ControlWrapper((Control)obj, this);
        }
        if (this.log.isWarnEnabled()) {
            this.log.warn((Object)("Invalid BioPAX object to wrap as node. Ignoring: " + obj));
        }
        return null;
    }

    @Override
    public String getKey(Object wrapped) {
        if (wrapped instanceof BioPAXElement) {
            return ((BioPAXElement)wrapped).getRDFId();
        }
        throw new IllegalArgumentException("Object cannot be wrapped: " + wrapped);
    }

    public Set<PhysicalEntity> getPhysical(Set<EntityReference> refs) {
        HashSet<PhysicalEntity> set = new HashSet<PhysicalEntity>();
        for (EntityReference ref : refs) {
            set.addAll(ref.getEntityReferenceOf());
        }
        return set;
    }

    @Override
    public Set<Node> getWrapperSet(Set<?> objects) {
        HashSet<Node> wrapped = new HashSet<Node>();
        for (Object object : objects) {
            Node node = (Node)this.getGraphObject(object);
            if (node == null) continue;
            wrapped.add(node);
        }
        return wrapped;
    }

    @Override
    public Map<Object, Node> getWrapperMap(Set<?> objects) {
        HashMap<Object, Node> map = new HashMap<Object, Node>();
        for (Object object : objects) {
            Node node = (Node)this.getGraphObject(object);
            if (node == null) continue;
            map.put(object, node);
        }
        return map;
    }

    @Override
    public Set<Object> getWrappedSet(Set<? extends GraphObject> wrappers) {
        HashSet<Object> objects = new HashSet<Object>();
        for (GraphObject graphObject : wrappers) {
            if (graphObject instanceof PhysicalEntityWrapper) {
                objects.add(((PhysicalEntityWrapper)graphObject).getPhysicalEntity());
                continue;
            }
            if (graphObject instanceof ConversionWrapper) {
                objects.add(((ConversionWrapper)graphObject).getConversion());
                continue;
            }
            if (graphObject instanceof TemplateReactionWrapper) {
                objects.add(((TemplateReactionWrapper)graphObject).getTempReac());
                continue;
            }
            if (!(graphObject instanceof ControlWrapper)) continue;
            objects.add(((ControlWrapper)graphObject).getControl());
        }
        return objects;
    }

    public Model getModel() {
        return this.model;
    }
}

