/*
 * Decompiled with CFR 0.152.
 */
package org.paxtools.query;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.biopax.paxtools.controller.Cloner;
import org.biopax.paxtools.controller.Completer;
import org.biopax.paxtools.controller.EditorMap;
import org.biopax.paxtools.controller.SimpleEditorMap;
import org.biopax.paxtools.io.BioPAXIOHandler;
import org.biopax.paxtools.io.SimpleIOHandler;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.query.QueryExecuter;
import org.biopax.paxtools.query.algorithm.Direction;
import org.biopax.paxtools.query.algorithm.LimitType;
import org.biopax.paxtools.query.wrapperL3.DataSourceFilter;
import org.biopax.paxtools.query.wrapperL3.Filter;
import org.biopax.paxtools.query.wrapperL3.OrganismFilter;
import org.biopax.paxtools.query.wrapperL3.UbiqueFilter;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class QueryTest {
    static final SimpleEditorMap EM = SimpleEditorMap.L3;
    static BioPAXIOHandler handler = new SimpleIOHandler();

    @Test
    public void testQueries() throws Throwable {
        Model model = handler.convertFromOWL(this.getClass().getResourceAsStream("raf_map_kinase_cascade_reactome.owl"));
        Set<BioPAXElement> source = QueryTest.findElements(model, "HTTP://WWW.REACTOME.ORG/BIOPAX/48887#PROTEIN2360_1_9606");
        Set<BioPAXElement> target = QueryTest.findElements(model, "HTTP://WWW.REACTOME.ORG/BIOPAX/48887#PROTEIN1631_1_9606");
        Set result = QueryExecuter.runNeighborhood(source, (Model)model, (int)1, (Direction)Direction.BOTHSTREAM, (Filter[])new Filter[0]);
        Assert.assertTrue((result.size() > 0 ? 1 : 0) != 0);
        result = QueryExecuter.runPathsFromTo(source, target, (Model)model, (LimitType)LimitType.NORMAL, (int)2, (Filter[])new Filter[0]);
        Assert.assertTrue((result.size() > 0 ? 1 : 0) != 0);
        result = QueryExecuter.runPathsFromTo(source, target, (Model)model, (LimitType)LimitType.NORMAL, (int)1, (Filter[])new Filter[0]);
        Assert.assertTrue((result.size() == 0 ? 1 : 0) != 0);
        source.addAll(target);
        result = QueryExecuter.runPathsBetween(source, (Model)model, (int)2, (Filter[])new Filter[0]);
        Assert.assertTrue((result.size() > 0 ? 1 : 0) != 0);
        result = QueryExecuter.runPathsBetween(source, (Model)model, (int)1, (Filter[])new Filter[0]);
        Assert.assertTrue((result.size() == 0 ? 1 : 0) != 0);
        source = QueryTest.findElements(model, "HTTP://WWW.REACTOME.ORG/BIOPAX/48887#PROTEIN1630_1_9606", "HTTP://WWW.REACTOME.ORG/BIOPAX/48887#PROTEIN2359_1_9606");
        result = QueryExecuter.runCommonStream(source, (Model)model, (Direction)Direction.DOWNSTREAM, (int)1, (Filter[])new Filter[0]);
        Assert.assertTrue((result.size() == 1 ? 1 : 0) != 0);
        result = QueryExecuter.runCommonStream(source, (Model)model, (Direction)Direction.DOWNSTREAM, (int)2, (Filter[])new Filter[0]);
        Assert.assertTrue((result.size() == 5 ? 1 : 0) != 0);
        result = QueryExecuter.runCommonStream(source, (Model)model, (Direction)Direction.DOWNSTREAM, (int)3, (Filter[])new Filter[0]);
        Assert.assertTrue((result.size() == 10 ? 1 : 0) != 0);
        source = QueryTest.findElements(model, "HTTP://WWW.REACTOME.ORG/BIOPAX/48887#PROTEIN1630_1_9606");
        target = QueryTest.findElements(model, "HTTP://WWW.REACTOME.ORG/BIOPAX/48887#PROTEIN1624_1_9606");
        result = QueryExecuter.runPathsFromTo(source, target, (Model)model, (LimitType)LimitType.NORMAL, (int)3, (Filter[])new Filter[0]);
        Assert.assertTrue((result.size() == 7 ? 1 : 0) != 0);
        Model clonedModel = this.excise(model, result);
        handler.convertToOWL(clonedModel, (OutputStream)new FileOutputStream(this.getClass().getResource("").getFile() + File.separator + "temp.owl"));
    }

    private Model excise(Model model, Set<BioPAXElement> result) {
        Completer c = new Completer((EditorMap)EM);
        result = c.complete(result, model);
        Cloner cln = new Cloner((EditorMap)EM, BioPAXLevel.L3.getDefaultFactory());
        return cln.clone(model, result);
    }

    protected static Set<BioPAXElement> findElements(Model model, String ... ids) {
        HashSet<BioPAXElement> set = new HashSet<BioPAXElement>();
        for (String id : ids) {
            BioPAXElement bpe = model.getByID(id);
            if (bpe == null) continue;
            set.add(bpe);
        }
        return set;
    }

    @Test
    @Ignore
    public void testQueryPerformance() throws IOException {
        long time = System.currentTimeMillis();
        InputStream in = this.getClass().getResourceAsStream("/Meiotic_Recombination.owl");
        Model model = handler.convertFromOWL(in);
        System.out.print("Read the model in ");
        long secs = (System.currentTimeMillis() - time) / 1000L;
        System.out.println(secs + " secs");
        time = System.currentTimeMillis();
        BioPAXElement s1 = model.getByID("HTTP://WWW.REACTOME.ORG/BIOPAX/48887#PROTEIN6022_1_9606");
        BioPAXElement t1 = model.getByID("HTTP://WWW.REACTOME.ORG/BIOPAX/48887#PROTEIN6020_1_9606");
        HashSet<BioPAXElement> source = new HashSet<BioPAXElement>();
        source.add(s1);
        source.add(t1);
        Set result = QueryExecuter.runCommonStreamWithPOI(source, (Model)model, (Direction)Direction.DOWNSTREAM, (int)3, null);
        secs = System.currentTimeMillis() - time;
        System.out.println("result.size() = " + result.size());
        System.out.println("milisecs = " + secs);
        Model ex = this.excise(model, result);
        handler.convertToOWL(ex, (OutputStream)new FileOutputStream("QueryResult.owl"));
    }

    @Test
    public void testFilters() {
        Model model = handler.convertFromOWL(this.getClass().getResourceAsStream("raf_map_kinase_cascade_reactome.owl"));
        Set<BioPAXElement> source = QueryTest.findElements(model, "HTTP://WWW.REACTOME.ORG/BIOPAX/48887#PROTEIN2360_1_9606");
        Set<BioPAXElement> target = QueryTest.findElements(model, "HTTP://WWW.REACTOME.ORG/BIOPAX/48887#PROTEIN1631_1_9606");
        OrganismFilter f = new OrganismFilter(new String[]{"Homo sapiens"});
        Set result = QueryExecuter.runPathsFromTo(source, target, (Model)model, (LimitType)LimitType.NORMAL, (int)2, (Filter[])new Filter[]{f});
        Assert.assertTrue((!result.isEmpty() ? 1 : 0) != 0);
        f = new OrganismFilter(new String[]{"Non-existing organism"});
        result = QueryExecuter.runPathsFromTo(source, target, (Model)model, (LimitType)LimitType.NORMAL, (int)2, (Filter[])new Filter[]{f});
        Assert.assertTrue((boolean)result.isEmpty());
        f = new OrganismFilter(new String[]{"9606"});
        result = QueryExecuter.runPathsFromTo(source, target, (Model)model, (LimitType)LimitType.NORMAL, (int)2, (Filter[])new Filter[]{f});
        Assert.assertTrue((!result.isEmpty() ? 1 : 0) != 0);
        f = new DataSourceFilter(new String[]{"Reactome"});
        result = QueryExecuter.runPathsFromTo(source, target, (Model)model, (LimitType)LimitType.NORMAL, (int)2, (Filter[])new Filter[]{f});
        Assert.assertTrue((!result.isEmpty() ? 1 : 0) != 0);
        f = new DataSourceFilter(new String[]{"Some DB"});
        result = QueryExecuter.runPathsFromTo(source, target, (Model)model, (LimitType)LimitType.NORMAL, (int)2, (Filter[])new Filter[]{f});
        Assert.assertTrue((boolean)result.isEmpty());
        result = QueryExecuter.runPathsFromTo(source, target, (Model)model, (LimitType)LimitType.NORMAL, (int)2, (Filter[])new Filter[]{new OrganismFilter(new String[]{"Homo sapiens"}), new DataSourceFilter(new String[]{"Reactome"})});
        Assert.assertTrue((!result.isEmpty() ? 1 : 0) != 0);
        source = QueryTest.findElements(model, "HTTP://WWW.REACTOME.ORG/BIOPAX/48887#SMALLMOLECULE5_1_9606");
        target = QueryTest.findElements(model, "HTTP://WWW.REACTOME.ORG/BIOPAX/48887#SMALLMOLECULE6_1_9606");
        HashSet<String> ubiqueIDs = new HashSet<String>(Arrays.asList("Some ID", "Another ID"));
        result = QueryExecuter.runPathsFromTo(source, target, (Model)model, (LimitType)LimitType.NORMAL, (int)1, (Filter[])new Filter[]{new UbiqueFilter(ubiqueIDs)});
        Assert.assertTrue((!result.isEmpty() ? 1 : 0) != 0);
        ubiqueIDs = new HashSet<String>(Arrays.asList("HTTP://WWW.REACTOME.ORG/BIOPAX/48887#SMALLMOLECULE5_1_9606"));
        result = QueryExecuter.runPathsFromTo(source, target, (Model)model, (LimitType)LimitType.NORMAL, (int)1, (Filter[])new Filter[]{new UbiqueFilter(ubiqueIDs)});
        Assert.assertTrue((boolean)result.isEmpty());
    }
}

