/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.query.wrapperL3;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.controller.PathAccessor;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.Level3Element;
import org.biopax.paxtools.query.wrapperL3.Filter;

public abstract class StringFieldFilter
extends Filter {
    Map<PathAccessor, Class<? extends BioPAXElement>> accessors;
    Set<String> validValues;
    protected boolean emptyOK;

    protected StringFieldFilter(boolean emptyOK, String[] valid) {
        this.setEmptyOK(emptyOK);
        this.accessors = new HashMap<PathAccessor, Class<? extends BioPAXElement>>();
        this.validValues = valid == null || valid.length == 0 ? Collections.EMPTY_SET : new HashSet<String>(Arrays.asList(valid));
        this.createFieldAccessors();
    }

    public boolean isEmptyOK() {
        return this.emptyOK;
    }

    public void setEmptyOK(boolean emptyOK) {
        this.emptyOK = emptyOK;
    }

    public abstract void createFieldAccessors();

    protected void addAccessor(PathAccessor acc, Class<? extends BioPAXElement> clazz) {
        this.accessors.put(acc, clazz);
    }

    protected void addValidValue(String value) {
        this.validValues.add(value);
    }

    @Override
    public boolean okToTraverse(Level3Element ele) {
        if (this.validValues.isEmpty()) {
            return true;
        }
        boolean empty = true;
        boolean objectRelevant = false;
        for (PathAccessor acc : this.accessors.keySet()) {
            Class<? extends BioPAXElement> clazz = this.accessors.get(acc);
            if (!clazz.isAssignableFrom(ele.getClass())) continue;
            objectRelevant = true;
            Set values = acc.getValueFromBean((BioPAXElement)ele);
            if (empty) {
                empty = values.isEmpty();
            }
            for (Object o : values) {
                if (!this.validValues.contains(o.toString())) continue;
                return true;
            }
        }
        return !objectRelevant || empty && this.isEmptyOK();
    }
}

