/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.query.wrapperL3;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.ConversionDirectionType;
import org.biopax.paxtools.model.level3.Interaction;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Process;
import org.biopax.paxtools.model.level3.TemplateReaction;
import org.biopax.paxtools.query.model.AbstractNode;
import org.biopax.paxtools.query.model.Node;
import org.biopax.paxtools.query.wrapperL3.ConversionWrapper;
import org.biopax.paxtools.query.wrapperL3.EdgeL3;
import org.biopax.paxtools.query.wrapperL3.GraphL3;
import org.biopax.paxtools.query.wrapperL3.TemplateReactionWrapper;

public class PhysicalEntityWrapper
extends AbstractNode {
    protected PhysicalEntity pe;
    protected boolean upperEquivalentInited;
    protected boolean lowerEquivalentInited;
    protected boolean ubique;

    public PhysicalEntityWrapper(PhysicalEntity pe, GraphL3 graph) {
        super(graph);
        this.pe = pe;
        this.upperEquivalentInited = false;
        this.lowerEquivalentInited = false;
        this.ubique = false;
    }

    @Override
    public boolean isUbique() {
        return this.ubique;
    }

    public void setUbique(boolean ubique) {
        this.ubique = ubique;
    }

    @Override
    public void initUpstream() {
        for (Conversion conv : this.getUpstreamConversions(this.pe.getParticipantOf())) {
            ConversionWrapper conW = (ConversionWrapper)this.graph.getGraphObject(conv);
            if (conW == null) continue;
            if (conv.getConversionDirection() == ConversionDirectionType.REVERSIBLE && conv.getLeft().contains(this.pe)) {
                conW = conW.getReverse();
            }
            EdgeL3 edge = new EdgeL3(conW, this, this.graph);
            conW.getDownstreamNoInit().add(edge);
            this.getUpstreamNoInit().add(edge);
        }
        for (Interaction inter : this.pe.getParticipantOf()) {
            TemplateReaction tr;
            TemplateReactionWrapper trw;
            if (!(inter instanceof TemplateReaction) || (trw = (TemplateReactionWrapper)this.graph.getGraphObject(tr = (TemplateReaction)inter)) == null) continue;
            EdgeL3 edge = new EdgeL3(trw, this, this.graph);
            assert (trw.getDownstreamNoInit() != null);
            trw.getDownstreamNoInit().add(edge);
            this.getUpstreamNoInit().add(edge);
        }
    }

    @Override
    public void initDownstream() {
        for (Interaction inter : this.getDownstreamInteractions(this.pe.getParticipantOf())) {
            AbstractNode node = (AbstractNode)this.graph.getGraphObject(inter);
            if (node == null) continue;
            if (inter instanceof Conversion) {
                Conversion conv = (Conversion)inter;
                ConversionWrapper conW = (ConversionWrapper)node;
                if (conv.getConversionDirection() == ConversionDirectionType.REVERSIBLE && conv.getRight().contains(this.pe)) {
                    node = conW.getReverse();
                }
            }
            EdgeL3 edge = new EdgeL3(this, node, this.graph);
            this.getDownstreamNoInit().add(edge);
            node.getUpstreamNoInit().add(edge);
        }
    }

    protected Set<Conversion> getUpstreamConversions(Collection<Interaction> inters) {
        HashSet<Conversion> set = new HashSet<Conversion>();
        for (Interaction inter : inters) {
            Conversion conv;
            ConversionDirectionType dir;
            if (!(inter instanceof Conversion) || (dir = (conv = (Conversion)inter).getConversionDirection()) != ConversionDirectionType.REVERSIBLE && (dir != ConversionDirectionType.RIGHT_TO_LEFT || !conv.getLeft().contains(this.pe)) && (dir != ConversionDirectionType.LEFT_TO_RIGHT && dir != null || !conv.getRight().contains(this.pe))) continue;
            set.add(conv);
        }
        return set;
    }

    protected Set<Interaction> getDownstreamInteractions(Collection<Interaction> inters) {
        HashSet<Interaction> set = new HashSet<Interaction>();
        for (Interaction inter : inters) {
            if (inter instanceof Conversion) {
                Conversion conv = (Conversion)inter;
                ConversionDirectionType dir = conv.getConversionDirection();
                if (dir != ConversionDirectionType.REVERSIBLE && (dir != ConversionDirectionType.RIGHT_TO_LEFT || !conv.getRight().contains(this.pe)) && (dir != ConversionDirectionType.LEFT_TO_RIGHT && dir != null || !conv.getLeft().contains(this.pe))) continue;
                set.add((Interaction)conv);
                continue;
            }
            if (!(inter instanceof Control)) continue;
            set.add(inter);
        }
        return set;
    }

    private Set<Conversion> getRelatedConversions(Collection<Interaction> inters) {
        HashSet<Conversion> set = new HashSet<Conversion>();
        for (Interaction inter : inters) {
            if (inter instanceof Conversion) {
                set.add((Conversion)inter);
                continue;
            }
            if (!(inter instanceof Control)) continue;
            this.getRelatedConversions((Control)inter, set);
        }
        return set;
    }

    private Set<Conversion> getRelatedConversions(Control ctrl, Set<Conversion> set) {
        for (Process process : ctrl.getControlled()) {
            if (process instanceof Conversion) {
                set.add((Conversion)process);
                continue;
            }
            if (!(process instanceof Control)) continue;
            this.getRelatedConversions((Control)process, set);
        }
        return set;
    }

    @Override
    public Collection<Node> getUpperEquivalent() {
        if (!this.upperEquivalentInited) {
            this.initUpperEquivalent();
        }
        return super.getUpperEquivalent();
    }

    @Override
    public Collection<Node> getLowerEquivalent() {
        if (!this.lowerEquivalentInited) {
            this.initLowerEquivalent();
        }
        return super.getLowerEquivalent();
    }

    protected void initUpperEquivalent() {
        this.upperEquivalent = new HashSet();
        for (PhysicalEntity eq : this.pe.getMemberPhysicalEntityOf()) {
            Node node = (Node)this.graph.getGraphObject(eq);
            if (node == null) continue;
            this.upperEquivalent.add(node);
        }
        this.upperEquivalentInited = true;
    }

    protected void initLowerEquivalent() {
        this.lowerEquivalent = new HashSet();
        for (PhysicalEntity eq : this.pe.getMemberPhysicalEntity()) {
            Node node = (Node)this.graph.getGraphObject(eq);
            if (node == null) continue;
            this.lowerEquivalent.add(node);
        }
        this.lowerEquivalentInited = true;
    }

    @Override
    public boolean isBreadthNode() {
        return true;
    }

    @Override
    public int getSign() {
        return 1;
    }

    @Override
    public String getKey() {
        return this.pe.getRDFId();
    }

    public PhysicalEntity getPhysicalEntity() {
        return this.pe;
    }

    public String toString() {
        return this.pe.getDisplayName() + " -- " + this.pe.getRDFId();
    }
}

