/*
 * Decompiled with CFR 0.152.
 */
package org.mskcc.psibiopax.converter;

import java.io.InputStream;
import java.util.Collection;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level2.InteractionParticipant;
import org.biopax.paxtools.model.level2.bioSource;
import org.biopax.paxtools.model.level2.openControlledVocabulary;
import org.biopax.paxtools.model.level2.physicalEntity;
import org.biopax.paxtools.model.level2.physicalInteraction;
import org.biopax.paxtools.model.level2.sequenceEntity;
import org.biopax.paxtools.model.level2.sequenceFeature;
import org.biopax.paxtools.model.level2.sequenceParticipant;
import org.biopax.paxtools.model.level2.unificationXref;
import org.biopax.paxtools.model.level2.xref;
import org.mskcc.psibiopax.converter.BioPAXMapper;
import org.mskcc.psibiopax.converter.BioPAXMapperImp;
import org.mskcc.psibiopax.converter.BioPAXMarshaller;
import org.mskcc.psibiopax.converter.EntryMapper;
import psidev.psi.mi.xml.PsimiXmlReader;
import psidev.psi.mi.xml.model.Entry;
import psidev.psi.mi.xml.model.EntrySet;

public class TestMappingL2
extends TestCase
implements BioPAXMarshaller {
    private static final String PSI_MI_TEST_FILE = "10523676-compact.xml";
    private Model bpModel;
    private final Object syncObj = new Object();

    public String getName() {
        return "TestMapping: Tests the proper mapping of a PSI-MI XML file (level 2-compact) to an in memory Paxtools Model";
    }

    public static Test suite() {
        return new TestSuite(TestMappingL2.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestMappingL2.suite());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMapping() {
        try {
            PsimiXmlReader reader = new PsimiXmlReader();
            InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(PSI_MI_TEST_FILE);
            EntrySet es = reader.read(is);
            is.close();
            Collection entries = es.getEntries();
            Assert.assertEquals((int)entries.size(), (int)1);
            BioPAXMapperImp bpMapper = new BioPAXMapperImp(BioPAXLevel.L2);
            bpMapper.setNamespace("HTTP://PATHWAYCOMMONS.ORG/PSI2BP#");
            Entry entry = (Entry)entries.iterator().next();
            EntryMapper mapper = new EntryMapper((BioPAXMapper)bpMapper, (BioPAXMarshaller)this, entry, 1970L);
            mapper.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        while (true) {
            Object e = this.syncObj;
            synchronized (e) {
                if (this.bpModel != null) {
                    break;
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
                System.exit(1);
            }
        }
        this.checkModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModel(Model bpModel) {
        Object object = this.syncObj;
        synchronized (object) {
            this.bpModel = bpModel;
        }
    }

    private void checkModel() {
        Set biopaxElements = this.bpModel.getObjects();
        Assert.assertEquals((int)145, (int)biopaxElements.size());
        BioPAXElement bpElement = null;
        for (BioPAXElement biopaxElement : biopaxElements) {
            if (!biopaxElement.getRDFId().equals("HTTP://PATHWAYCOMMONS.ORG/PSI2BP#_3323281832130706316")) continue;
            bpElement = biopaxElement;
            break;
        }
        Assert.assertTrue((bpElement != null ? 1 : 0) != 0);
        physicalInteraction bpInteraction = (physicalInteraction)bpElement;
        Set interactionParticipants = bpInteraction.getPARTICIPANTS();
        Assert.assertEquals((int)2, (int)interactionParticipants.size());
        sequenceParticipant participant = null;
        for (InteractionParticipant interactionParticipant : interactionParticipants) {
            if (!interactionParticipant.getRDFId().equals("HTTP://PATHWAYCOMMONS.ORG/PSI2BP#_5767007948877890882")) continue;
            participant = (sequenceParticipant)interactionParticipant;
        }
        Assert.assertTrue((participant != null ? 1 : 0) != 0);
        this.checkSequenceFeatures(participant);
        this.checkPhysicalEntity(participant);
    }

    private void checkSequenceFeatures(sequenceParticipant participant) {
        Set sequenceFeatureList = participant.getSEQUENCE_FEATURE_LIST();
        Assert.assertEquals((int)1, (int)sequenceFeatureList.size());
        boolean featureFound = false;
        sequenceFeature bpSequenceFeature = null;
        for (sequenceFeature sf : sequenceFeatureList) {
            if (!sf.getRDFId().equals("HTTP://PATHWAYCOMMONS.ORG/PSI2BP#_2681741952554656410")) continue;
            featureFound = true;
            bpSequenceFeature = sf;
            break;
        }
        Assert.assertTrue((boolean)featureFound);
        boolean featureTypeFound = false;
        openControlledVocabulary featureType = bpSequenceFeature.getFEATURE_TYPE();
        Set featureTypes = featureType.getTERM();
        for (String ft : featureTypes) {
            if (!ft.equals("ha tagged")) continue;
            featureTypeFound = true;
            break;
        }
        Assert.assertTrue((boolean)featureTypeFound);
        Set featureLocation = bpSequenceFeature.getFEATURE_LOCATION();
        Assert.assertEquals((int)0, (int)featureLocation.size());
    }

    private void checkPhysicalEntity(sequenceParticipant participant) {
        physicalEntity bpPhysicalEntity = participant.getPHYSICAL_ENTITY();
        Assert.assertEquals((String)"HTTP://PATHWAYCOMMONS.ORG/PSI2BP#_8", (String)bpPhysicalEntity.getRDFId());
        Assert.assertEquals((String)"DNA primase small subunit", (String)bpPhysicalEntity.getNAME());
        Assert.assertEquals((String)"pri1_mouse", (String)bpPhysicalEntity.getSHORT_NAME());
        Set physicalEntityXRefList = bpPhysicalEntity.getXREF();
        Assert.assertEquals((int)4, (int)physicalEntityXRefList.size());
        xref physicalEntityXRef = null;
        for (xref x : physicalEntityXRefList) {
            if (!(x instanceof unificationXref)) continue;
            physicalEntityXRef = x;
            break;
        }
        if (physicalEntityXRef == null) {
            TestMappingL2.fail((String)"no unification xrefs found!");
        }
        Assert.assertEquals((String)"HTTP://PATHWAYCOMMONS.ORG/PSI2BP#UXR-P20664", (String)physicalEntityXRef.getRDFId());
        Assert.assertEquals((String)"uniprotkb", (String)physicalEntityXRef.getDB());
        Assert.assertEquals((String)"P20664", (String)physicalEntityXRef.getID());
        bioSource bpBioSource = ((sequenceEntity)bpPhysicalEntity).getORGANISM();
        Assert.assertEquals((String)"Mus musculus", (String)bpBioSource.getNAME());
        Assert.assertEquals((String)"HTTP://PATHWAYCOMMONS.ORG/PSI2BP#BS-10090", (String)bpBioSource.getRDFId());
        unificationXref bioSourceXRef = bpBioSource.getTAXON_XREF();
        Assert.assertEquals((String)"HTTP://PATHWAYCOMMONS.ORG/PSI2BP#_8992476572203004810", (String)bioSourceXRef.getRDFId());
        Assert.assertEquals((String)"TAXONOMY", (String)bioSourceXRef.getDB());
        Assert.assertEquals((String)"10090", (String)bioSourceXRef.getID());
        Assert.assertEquals((String)"MEPFDPAELPELLKLYYRRLFPYAQYYRWLNYGGVTKNYFQHREFSFTLKDDIYIRYQSFNNQSELEKEMQKMNPYKIDIGAVYSHRPNQHNTVKLGAFQAQEKELVFDIDMTDYDDVRRCCSSADICSKCWTLMTMAMRIIDRALKEDFGFKHRLWVYSGRRGVHCWVCDESVRKLSSAVRSGIVEYLSLVKGGQDVKKKVHLNEKVHPFVRKSINIIKKYFEEYALVGQDILENKENWDKILALVPETIHDELQRGFQKFHSSPQRWEHLRKVANSSQNMKNDKCGPWLEWEVMLQYCFPRLDVNVSKGVNHLLKSPFSVHPKTGRISVPIDFHKVDQFDPFTVPTISAICRELDMVSTHEKEKEENEADSKHRVRGYKKTSLAPYVKVFEQFLENLDKSRKGELLKKSDLQKDF", (String)((sequenceEntity)bpPhysicalEntity).getSEQUENCE());
    }
}

