/*
 * Decompiled with CFR 0.152.
 */
package org.mskcc.psibiopax.converter;

import java.io.InputStream;
import java.util.Collection;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.BioSource;
import org.biopax.paxtools.model.level3.EntityFeature;
import org.biopax.paxtools.model.level3.MolecularInteraction;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Protein;
import org.biopax.paxtools.model.level3.ProteinReference;
import org.biopax.paxtools.model.level3.SequenceLocation;
import org.biopax.paxtools.model.level3.SequenceRegionVocabulary;
import org.biopax.paxtools.model.level3.UnificationXref;
import org.biopax.paxtools.model.level3.Xref;
import org.mskcc.psibiopax.converter.BioPAXMapper;
import org.mskcc.psibiopax.converter.BioPAXMapperImp;
import org.mskcc.psibiopax.converter.BioPAXMarshaller;
import org.mskcc.psibiopax.converter.EntryMapper;
import psidev.psi.mi.xml.PsimiXmlReader;
import psidev.psi.mi.xml.model.Entry;
import psidev.psi.mi.xml.model.EntrySet;

public class TestMappingL3
extends TestCase
implements BioPAXMarshaller {
    private static final String PSI_MI_TEST_FILE = "10523676-compact.xml";
    private Model bpModel;
    private final Object syncObj = new Object();

    public String getName() {
        return "TestMapping: Tests the proper mapping of a PSI-MI XML file (level 2-compact) to an in memory Paxtools Model";
    }

    public static Test suite() {
        return new TestSuite(TestMappingL3.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TestMappingL3.suite());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMapping() {
        try {
            PsimiXmlReader reader = new PsimiXmlReader();
            InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(PSI_MI_TEST_FILE);
            EntrySet es = reader.read(is);
            is.close();
            Collection entries = es.getEntries();
            Assert.assertEquals((int)entries.size(), (int)1);
            BioPAXMapperImp bpMapper = new BioPAXMapperImp(BioPAXLevel.L3);
            bpMapper.setNamespace("HTTP://PATHWAYCOMMONS.ORG/PSI2BP#");
            Entry entry = (Entry)entries.iterator().next();
            EntryMapper mapper = new EntryMapper((BioPAXMapper)bpMapper, (BioPAXMarshaller)this, entry, 1970L);
            mapper.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        while (true) {
            Object e = this.syncObj;
            synchronized (e) {
                if (this.bpModel != null) {
                    break;
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
                System.exit(1);
            }
        }
        this.checkModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModel(Model bpModel) {
        Object object = this.syncObj;
        synchronized (object) {
            this.bpModel = bpModel;
        }
    }

    private void checkModel() {
        Set biopaxElements = this.bpModel.getObjects();
        Assert.assertEquals((int)122, (int)biopaxElements.size());
        BioPAXElement bpElement = null;
        for (BioPAXElement biopaxElement : biopaxElements) {
            if (!biopaxElement.getRDFId().equals("HTTP://PATHWAYCOMMONS.ORG/PSI2BP#_8694781173405777161")) continue;
            bpElement = biopaxElement;
            break;
        }
        Assert.assertTrue((bpElement != null ? 1 : 0) != 0);
        MolecularInteraction bpInteraction = (MolecularInteraction)bpElement;
        Set interactionParticipants = bpInteraction.getParticipant();
        Assert.assertEquals((int)2, (int)interactionParticipants.size());
        Protein participant = null;
        for (PhysicalEntity interactionParticipant : interactionParticipants) {
            if (!interactionParticipant.getRDFId().equals("HTTP://PATHWAYCOMMONS.ORG/PSI2BP#_8")) continue;
            participant = (Protein)interactionParticipant;
        }
        Assert.assertTrue((participant != null ? 1 : 0) != 0);
        this.checkSequenceFeatures(participant);
        this.checkPhysicalEntity(participant);
    }

    private void checkSequenceFeatures(Protein participant) {
        Set entityFeatureList = participant.getFeature();
        Assert.assertEquals((int)4, (int)entityFeatureList.size());
        boolean featureFound = false;
        EntityFeature bpEntityFeature = null;
        for (EntityFeature ef : entityFeatureList) {
            if (!ef.getRDFId().equals("HTTP://PATHWAYCOMMONS.ORG/PSI2BP#_2681741952554656410")) continue;
            featureFound = true;
            bpEntityFeature = ef;
            break;
        }
        SequenceLocation sequenceLocation = bpEntityFeature.getFeatureLocation();
        Assert.assertEquals(null, (Object)sequenceLocation);
        boolean featureLocationTypeFound = false;
        SequenceRegionVocabulary featureLocationType = bpEntityFeature.getFeatureLocationType();
        Set featureLocationTypes = featureLocationType.getTerm();
        for (String flt : featureLocationTypes) {
            if (!flt.equals("ha tagged")) continue;
            featureLocationTypeFound = true;
            break;
        }
        Assert.assertTrue((boolean)featureLocationTypeFound);
    }

    private void checkPhysicalEntity(Protein participant) {
        Assert.assertEquals((String)"HTTP://PATHWAYCOMMONS.ORG/PSI2BP#_8", (String)participant.getRDFId());
        Assert.assertEquals((String)"Prim1", (String)((String)participant.getName().iterator().next()));
        Set physicalEntityXRefList = participant.getXref();
        Assert.assertEquals((int)4, (int)physicalEntityXRefList.size());
        Xref physicalEntityXRef = null;
        for (Xref x : physicalEntityXRefList) {
            if (!(x instanceof UnificationXref)) continue;
            physicalEntityXRef = x;
            break;
        }
        if (physicalEntityXRef == null) {
            TestMappingL3.fail((String)"no unification xrefs found!");
        }
        Assert.assertEquals((String)"HTTP://PATHWAYCOMMONS.ORG/PSI2BP#UXR-P20664", (String)physicalEntityXRef.getRDFId());
        Assert.assertEquals((String)"uniprotkb", (String)physicalEntityXRef.getDb());
        Assert.assertEquals((String)"P20664", (String)physicalEntityXRef.getId());
        ProteinReference proteinReference = (ProteinReference)participant.getEntityReference();
        BioSource bpBioSource = proteinReference.getOrganism();
        Assert.assertEquals((String)"Mus musculus", (String)((String)bpBioSource.getName().iterator().next()));
        Assert.assertEquals((String)"HTTP://PATHWAYCOMMONS.ORG/PSI2BP#BS-10090", (String)bpBioSource.getRDFId());
        Set bioSourceXRef = bpBioSource.getXref();
        Assert.assertEquals((int)1, (int)bioSourceXRef.size());
        for (Xref unificationXref2 : bioSourceXRef) {
            Assert.assertEquals((String)"HTTP://PATHWAYCOMMONS.ORG/PSI2BP#_8992476572203004810", (String)unificationXref2.getRDFId());
            Assert.assertEquals((String)"TAXONOMY", (String)unificationXref2.getDb());
            Assert.assertEquals((String)"10090", (String)unificationXref2.getId());
        }
        Assert.assertEquals((String)"MEPFDPAELPELLKLYYRRLFPYAQYYRWLNYGGVTKNYFQHREFSFTLKDDIYIRYQSFNNQSELEKEMQKMNPYKIDIGAVYSHRPNQHNTVKLGAFQAQEKELVFDIDMTDYDDVRRCCSSADICSKCWTLMTMAMRIIDRALKEDFGFKHRLWVYSGRRGVHCWVCDESVRKLSSAVRSGIVEYLSLVKGGQDVKKKVHLNEKVHPFVRKSINIIKKYFEEYALVGQDILENKENWDKILALVPETIHDELQRGFQKFHSSPQRWEHLRKVANSSQNMKNDKCGPWLEWEVMLQYCFPRLDVNVSKGVNHLLKSPFSVHPKTGRISVPIDFHKVDQFDPFTVPTISAICRELDMVSTHEKEKEENEADSKHRVRGYKKTSLAPYVKVFEQFLENLDKSRKGELLKKSDLQKDF", (String)proteinReference.getSequence());
    }
}

