/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sbgn;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.conversion.HGNC;
import org.biopax.paxtools.io.sbgn.SBGNLayoutManager;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.BioPAXLevel;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.Catalysis;
import org.biopax.paxtools.model.level3.CatalysisDirectionType;
import org.biopax.paxtools.model.level3.CellularLocationVocabulary;
import org.biopax.paxtools.model.level3.Complex;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.ControlType;
import org.biopax.paxtools.model.level3.Controller;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.ConversionDirectionType;
import org.biopax.paxtools.model.level3.Dna;
import org.biopax.paxtools.model.level3.DnaRegion;
import org.biopax.paxtools.model.level3.EntityFeature;
import org.biopax.paxtools.model.level3.EntityReference;
import org.biopax.paxtools.model.level3.FragmentFeature;
import org.biopax.paxtools.model.level3.ModificationFeature;
import org.biopax.paxtools.model.level3.NucleicAcid;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Protein;
import org.biopax.paxtools.model.level3.Rna;
import org.biopax.paxtools.model.level3.RnaRegion;
import org.biopax.paxtools.model.level3.SequenceLocation;
import org.biopax.paxtools.model.level3.SequenceModificationVocabulary;
import org.biopax.paxtools.model.level3.SimplePhysicalEntity;
import org.biopax.paxtools.model.level3.SmallMolecule;
import org.biopax.paxtools.model.level3.TemplateReaction;
import org.biopax.paxtools.model.level3.Xref;
import org.sbgn.ArcClazz;
import org.sbgn.GlyphClazz;
import org.sbgn.Language;
import org.sbgn.SbgnUtil;
import org.sbgn.bindings.Arc;
import org.sbgn.bindings.Glyph;
import org.sbgn.bindings.Label;
import org.sbgn.bindings.Map;
import org.sbgn.bindings.ObjectFactory;
import org.sbgn.bindings.Port;
import org.sbgn.bindings.Sbgn;

public class L3ToSBGNPDConverter {
    private static final Log log = LogFactory.getLog(L3ToSBGNPDConverter.class);
    private static java.util.Map<Class<? extends BioPAXElement>, String> typeMatchMap;
    private static ObjectFactory factory;

    public static void writeSBGN(Model model, String file) {
        block2: {
            Sbgn sbgn = L3ToSBGNPDConverter.createSBGN(model);
            try {
                SbgnUtil.writeToFile((Sbgn)sbgn, (File)new File(file));
            }
            catch (JAXBException e) {
                if (!log.isErrorEnabled()) break block2;
                log.error((Object)e.getCause(), (Throwable)e);
            }
        }
    }

    public static Sbgn createSBGN(Model model) {
        assert (model.getLevel().equals((Object)BioPAXLevel.L3)) : "This method only supports L3 graphs";
        HashMap<String, Glyph> glyphMap = new HashMap<String, Glyph>();
        HashMap<String, Glyph> compartmentMap = new HashMap<String, Glyph>();
        HashMap<String, Arc> arcMap = new HashMap<String, Arc>();
        for (PhysicalEntity entity : model.getObjects(PhysicalEntity.class)) {
            if (!L3ToSBGNPDConverter.needsToBeRepresented(entity)) continue;
            L3ToSBGNPDConverter.createGlyph(entity, glyphMap, compartmentMap);
        }
        for (Conversion conv : model.getObjects(Conversion.class)) {
            if (conv.getConversionDirection() == null || conv.getConversionDirection().equals((Object)ConversionDirectionType.LEFT_TO_RIGHT) || conv.getConversionDirection().equals((Object)ConversionDirectionType.REVERSIBLE)) {
                L3ToSBGNPDConverter.createProcessAndConnections(conv, ConversionDirectionType.LEFT_TO_RIGHT, glyphMap, arcMap);
                continue;
            }
            if (conv.getConversionDirection() == null || !conv.getConversionDirection().equals((Object)ConversionDirectionType.RIGHT_TO_LEFT) && !conv.getConversionDirection().equals((Object)ConversionDirectionType.REVERSIBLE)) continue;
            L3ToSBGNPDConverter.createProcessAndConnections(conv, ConversionDirectionType.RIGHT_TO_LEFT, glyphMap, arcMap);
        }
        for (TemplateReaction tr : model.getObjects(TemplateReaction.class)) {
            L3ToSBGNPDConverter.createProcessAndConnections(tr, glyphMap, arcMap);
        }
        Sbgn sbgn = factory.createSbgn();
        Map map = new Map();
        sbgn.setMap(map);
        map.setLanguage(Language.PD.toString());
        map.getGlyph().addAll(L3ToSBGNPDConverter.getRootGlyphs(glyphMap.values()));
        map.getGlyph().addAll(compartmentMap.values());
        map.getArc().addAll(arcMap.values());
        SBGNLayoutManager coseLayoutManager = new SBGNLayoutManager();
        sbgn = coseLayoutManager.createLayout(sbgn);
        return sbgn;
    }

    private static boolean needsToBeRepresented(PhysicalEntity entity) {
        Complex c;
        return !(entity instanceof Complex ? (c = (Complex)entity).getParticipantOf().isEmpty() && !c.getComponentOf().isEmpty() : entity.getParticipantOf().isEmpty() && !entity.getComponentOf().isEmpty());
    }

    private static Glyph createGlyph(PhysicalEntity pe, java.util.Map<String, Glyph> glyphMap, java.util.Map<String, Glyph> compartmentMap) {
        if (glyphMap.containsKey(pe.getRDFId())) {
            return glyphMap.get(pe.getRDFId());
        }
        Glyph g = L3ToSBGNPDConverter.createGlyph(pe);
        glyphMap.put(g.getId(), g);
        Glyph loc = L3ToSBGNPDConverter.getCompartment(L3ToSBGNPDConverter.getCompartment(pe), compartmentMap);
        if (loc != null) {
            g.setCompartmentRef((Object)loc);
        }
        if (pe instanceof Complex) {
            L3ToSBGNPDConverter.createComplexContent((Complex)pe, glyphMap);
        }
        return g;
    }

    private static Glyph createGlyph(PhysicalEntity pe) {
        String s = typeMatchMap.get(pe.getModelInterface());
        Glyph g = factory.createGlyph();
        g.setId(pe.getRDFId());
        g.setClazz(s);
        Label label = factory.createLabel();
        label.setText(L3ToSBGNPDConverter.findALabelForMolecule(pe));
        g.setLabel(label);
        List<Glyph> states = L3ToSBGNPDConverter.getInformation(pe);
        g.getGlyph().addAll(states);
        return g;
    }

    private static void createComplexContent(Complex cx, java.util.Map<String, Glyph> glyphMap) {
        Glyph cg = glyphMap.get(cx.getRDFId());
        for (PhysicalEntity mem : cx.getComponent()) {
            if (mem instanceof Complex) {
                L3ToSBGNPDConverter.addComplexAsMember((Complex)mem, cg, glyphMap);
                continue;
            }
            L3ToSBGNPDConverter.createComplexMember(mem, cg, glyphMap);
        }
    }

    private static void addComplexAsMember(Complex cx, Glyph container, java.util.Map<String, Glyph> glyphMap) {
        if (cx.getComponent().isEmpty()) {
            L3ToSBGNPDConverter.createComplexMember((PhysicalEntity)cx, container, glyphMap);
        } else {
            for (PhysicalEntity mem : cx.getComponent()) {
                if (mem instanceof Complex) {
                    L3ToSBGNPDConverter.addComplexAsMember((Complex)mem, container, glyphMap);
                    continue;
                }
                L3ToSBGNPDConverter.createComplexMember(mem, container, glyphMap);
            }
        }
    }

    private static void createComplexMember(PhysicalEntity pe, Glyph container, java.util.Map<String, Glyph> glyphMap) {
        Glyph g = L3ToSBGNPDConverter.createGlyph(pe);
        container.getGlyph().add(g);
        g.setId(g.getId() + "|" + container.getId());
        glyphMap.put(g.getId(), g);
    }

    private static String findALabelForMolecule(PhysicalEntity pe) {
        String name;
        for (Xref xref : pe.getXref()) {
            String sym = L3ToSBGNPDConverter.extractGeneSymbol(xref);
            if (sym == null) continue;
            return sym;
        }
        EntityReference er = null;
        if (pe instanceof SimplePhysicalEntity) {
            er = ((SimplePhysicalEntity)pe).getEntityReference();
        }
        if (er != null) {
            for (Xref xref : er.getXref()) {
                String sym = L3ToSBGNPDConverter.extractGeneSymbol(xref);
                if (sym == null) continue;
                return sym;
            }
        }
        if ((name = pe.getDisplayName()) == null) {
            if (er != null) {
                name = er.getDisplayName();
            }
            if (name == null && (name = pe.getStandardName()) == null) {
                if (er != null) {
                    name = er.getStandardName();
                }
                if (name == null) {
                    if (!pe.getName().isEmpty()) {
                        name = (String)pe.getName().iterator().next();
                    } else if (er != null && !er.getName().isEmpty()) {
                        name = (String)er.getName().iterator().next();
                    }
                }
            }
        }
        if (name == null) {
            name = "noname";
        }
        return name;
    }

    private static String extractGeneSymbol(Xref xref) {
        if (xref.getDb() != null && (xref.getDb().equals("HGNC") || xref.getDb().equals("Gene Symbol"))) {
            String ref = xref.getId();
            if (ref != null) {
                if ((ref = ref.trim()).contains(":")) {
                    ref = ref.substring(ref.indexOf(":") + 1);
                }
                if (ref.contains("_")) {
                    ref = ref.substring(ref.indexOf("_") + 1);
                }
                if (!HGNC.containsSymbol((String)ref)) {
                    ref = HGNC.getSymbol((String)ref);
                }
            }
            return ref;
        }
        return null;
    }

    private static List<Glyph> getInformation(PhysicalEntity pe) {
        ArrayList<Glyph> list = new ArrayList<Glyph>();
        if (pe instanceof NucleicAcid) {
            Glyph g = factory.createGlyph();
            g.setClazz(GlyphClazz.UNIT_OF_INFORMATION.getClazz());
            Glyph.State s = factory.createGlyphState();
            s.setVariable("mt");
            s.setValue(pe instanceof Dna || pe instanceof DnaRegion ? "DNA" : (pe instanceof Rna || pe instanceof RnaRegion ? "RNA" : "NucleicAcid"));
            g.setState(s);
            list.add(g);
        }
        L3ToSBGNPDConverter.extractFeatures(pe.getFeature(), true, list);
        L3ToSBGNPDConverter.extractFeatures(pe.getNotFeature(), false, list);
        return list;
    }

    private static void extractFeatures(Set<EntityFeature> features, boolean normalFeature, List<Glyph> list) {
        for (EntityFeature feature : features) {
            SequenceLocation loc;
            if (!(feature instanceof ModificationFeature) && !(feature instanceof FragmentFeature)) continue;
            Glyph stvar = factory.createGlyph();
            stvar.setClazz(GlyphClazz.STATE_VARIABLE.getClazz());
            Glyph.State state = factory.createGlyphState();
            stvar.setState(state);
            if (feature instanceof ModificationFeature) {
                ModificationFeature mf = (ModificationFeature)feature;
                SequenceModificationVocabulary modificationType = mf.getModificationType();
                if (modificationType != null) {
                    state.setVariable(String.valueOf(modificationType));
                }
            } else {
                state.setVariable("Fragment");
            }
            if (!normalFeature) {
                state.setVariable("!" + state.getVariable());
            }
            if ((loc = feature.getFeatureLocation()) != null) {
                String value = loc.toString();
                state.setValue(value);
            }
            list.add(stvar);
        }
    }

    private static Glyph getCompartment(String name, java.util.Map<String, Glyph> compartmentMap) {
        if (name == null) {
            return null;
        }
        if (compartmentMap.containsKey(name)) {
            return compartmentMap.get(name);
        }
        Glyph comp = factory.createGlyph();
        comp.setId(name);
        Label label = factory.createLabel();
        label.setText(name);
        comp.setLabel(label);
        comp.setClazz(GlyphClazz.COMPARTMENT.getClazz());
        compartmentMap.put(name, comp);
        return comp;
    }

    private static String getCompartment(PhysicalEntity pe) {
        CellularLocationVocabulary cl = pe.getCellularLocation();
        if (cl != null && !cl.getTerm().isEmpty()) {
            return (String)cl.getTerm().iterator().next();
        }
        return null;
    }

    private static void createProcessAndConnections(Conversion cnv, ConversionDirectionType direction, java.util.Map<String, Glyph> glyphMap, java.util.Map<String, Arc> arcMap) {
        Glyph g;
        assert (direction.equals((Object)ConversionDirectionType.LEFT_TO_RIGHT) || direction.equals((Object)ConversionDirectionType.RIGHT_TO_LEFT));
        assert (cnv.getConversionDirection() == null || cnv.getConversionDirection().equals((Object)direction) || cnv.getConversionDirection().equals((Object)ConversionDirectionType.REVERSIBLE));
        Glyph process = factory.createGlyph();
        process.setClazz(GlyphClazz.PROCESS.getClazz());
        process.setId(cnv.getRDFId() + direction);
        glyphMap.put(process.getId(), process);
        Set input = direction.equals((Object)ConversionDirectionType.LEFT_TO_RIGHT) ? cnv.getLeft() : cnv.getRight();
        Set output = direction.equals((Object)ConversionDirectionType.RIGHT_TO_LEFT) ? cnv.getLeft() : cnv.getRight();
        L3ToSBGNPDConverter.addPorts(process);
        for (PhysicalEntity pe : input) {
            g = glyphMap.get(pe.getRDFId());
            L3ToSBGNPDConverter.createArc(g, process.getPort().get(0), ArcClazz.CONSUMPTION.getClazz(), arcMap);
        }
        for (PhysicalEntity pe : output) {
            g = glyphMap.get(pe.getRDFId());
            L3ToSBGNPDConverter.createArc(process.getPort().get(1), g, ArcClazz.PRODUCTION.getClazz(), arcMap);
        }
        for (Control ctrl : cnv.getControlledOf()) {
            CatalysisDirectionType catDir;
            if (ctrl instanceof Catalysis && (catDir = ((Catalysis)ctrl).getCatalysisDirection()) != null && (catDir.equals((Object)CatalysisDirectionType.LEFT_TO_RIGHT) && direction.equals((Object)ConversionDirectionType.RIGHT_TO_LEFT) || catDir.equals((Object)CatalysisDirectionType.RIGHT_TO_LEFT) && direction.equals((Object)ConversionDirectionType.LEFT_TO_RIGHT))) {
                if (direction.equals((Object)ConversionDirectionType.REVERSIBLE) || !log.isWarnEnabled()) continue;
                log.warn((Object)("A control is being lost due to direction mismatch.\nControl direction = " + catDir + "\nConversion direction = " + direction));
                continue;
            }
            g = L3ToSBGNPDConverter.createControlStructure(ctrl, glyphMap, arcMap);
            if (g == null) continue;
            L3ToSBGNPDConverter.createArc(g, process, L3ToSBGNPDConverter.getControlType(ctrl), arcMap);
        }
    }

    private static void createProcessAndConnections(TemplateReaction tr, java.util.Map<String, Glyph> glyphMap, java.util.Map<String, Arc> arcMap) {
        Glyph g;
        Glyph process = factory.createGlyph();
        process.setClazz(GlyphClazz.PROCESS.getClazz());
        process.setId(tr.getRDFId());
        glyphMap.put(process.getId(), process);
        L3ToSBGNPDConverter.addPorts(process);
        Glyph sas = factory.createGlyph();
        sas.setClazz(GlyphClazz.SOURCE_AND_SINK.getClazz());
        sas.setId("SAS_For_" + tr.getRDFId());
        glyphMap.put(sas.getId(), sas);
        L3ToSBGNPDConverter.createArc(sas, process.getPort().get(0), ArcClazz.CONSUMPTION.getClazz(), arcMap);
        for (PhysicalEntity pe : tr.getProduct()) {
            g = glyphMap.get(pe.getRDFId());
            L3ToSBGNPDConverter.createArc(process.getPort().get(1), g, ArcClazz.PRODUCTION.getClazz(), arcMap);
        }
        for (Control ctrl : tr.getControlledOf()) {
            g = L3ToSBGNPDConverter.createControlStructure(ctrl, glyphMap, arcMap);
            if (g == null) continue;
            L3ToSBGNPDConverter.createArc(g, process, L3ToSBGNPDConverter.getControlType(ctrl), arcMap);
        }
    }

    private static Glyph createControlStructure(Control ctrl, java.util.Map<String, Glyph> glyphMap, java.util.Map<String, Arc> arcMap) {
        Glyph cg;
        Set<PhysicalEntity> controllers = L3ToSBGNPDConverter.getControllers(ctrl, glyphMap);
        if (controllers.isEmpty()) {
            cg = null;
        } else if (controllers.size() == 1 && L3ToSBGNPDConverter.getControllerSize(ctrl.getControlledOf(), glyphMap) == 0) {
            cg = glyphMap.get(controllers.iterator().next().getRDFId());
        } else {
            Set cofs;
            Glyph g;
            ArrayList<Glyph> toConnect = new ArrayList<Glyph>();
            Glyph gg = L3ToSBGNPDConverter.handlePEGroup(controllers, glyphMap, arcMap);
            if (gg != null) {
                toConnect.add(gg);
            }
            for (Control ctrl2 : ctrl.getControlledOf()) {
                Glyph g2 = L3ToSBGNPDConverter.createControlStructure(ctrl2, glyphMap, arcMap);
                if (g2 == null) continue;
                if (L3ToSBGNPDConverter.getControlType(ctrl2).equals(ArcClazz.INHIBITION)) {
                    g2 = L3ToSBGNPDConverter.addNOT(g2, glyphMap, arcMap);
                }
                toConnect.add(g2);
            }
            if (ctrl instanceof Catalysis && (g = L3ToSBGNPDConverter.handlePEGroup(cofs = ((Catalysis)ctrl).getCofactor(), glyphMap, arcMap)) != null) {
                toConnect.add(g);
            }
            if (toConnect.isEmpty()) {
                return null;
            }
            cg = toConnect.size() == 1 ? (Glyph)toConnect.iterator().next() : L3ToSBGNPDConverter.connectWithAND(toConnect, glyphMap, arcMap);
        }
        return cg;
    }

    private static Glyph handlePEGroup(Set<PhysicalEntity> pes, java.util.Map<String, Glyph> glyphMap, java.util.Map<String, Arc> arcMap) {
        int sz = pes.size();
        if (sz > 1) {
            List<Glyph> gs = L3ToSBGNPDConverter.getGlyphsOfPEs(pes, glyphMap);
            return L3ToSBGNPDConverter.connectWithAND(gs, glyphMap, arcMap);
        }
        if (sz == 1 && glyphMap.containsKey(pes.iterator().next().getRDFId())) {
            return glyphMap.get(pes.iterator().next().getRDFId());
        }
        return null;
    }

    private static List<Glyph> getGlyphsOfPEs(Set<PhysicalEntity> pes, java.util.Map<String, Glyph> glyphMap) {
        ArrayList<Glyph> gs = new ArrayList<Glyph>();
        for (PhysicalEntity pe : pes) {
            if (!glyphMap.containsKey(pe.getRDFId())) continue;
            gs.add(glyphMap.get(pe.getRDFId()));
        }
        return gs;
    }

    private static Glyph connectWithAND(List<Glyph> gs, java.util.Map<String, Glyph> glyphMap, java.util.Map<String, Arc> arcMap) {
        Glyph and;
        String id = "";
        for (Glyph g : gs) {
            id = id + (id.length() > 0 ? "-AND-" : "") + g.getId();
        }
        if (!glyphMap.containsKey(id)) {
            and = factory.createGlyph();
            and.setClazz(GlyphClazz.AND.getClazz());
            and.setId(id);
            glyphMap.put(and.getId(), and);
        } else {
            and = glyphMap.get(id);
        }
        for (Glyph g : gs) {
            L3ToSBGNPDConverter.createArc(g, and, ArcClazz.LOGIC_ARC.getClazz(), arcMap);
        }
        return and;
    }

    private static Glyph addNOT(Glyph g, java.util.Map<String, Glyph> glyphMap, java.util.Map<String, Arc> arcMap) {
        Glyph not;
        String id = "NOT-" + g.getId();
        if (!glyphMap.containsKey(id)) {
            not = factory.createGlyph();
            not.setId(id);
            not.setClazz(GlyphClazz.NOT.getClazz());
            glyphMap.put(not.getId(), not);
        } else {
            not = glyphMap.get(id);
        }
        L3ToSBGNPDConverter.createArc(g, not, ArcClazz.LOGIC_ARC.getClazz(), arcMap);
        return not;
    }

    private static String getControlType(Control ctrl) {
        if (ctrl instanceof Catalysis) {
            return ArcClazz.CATALYSIS.getClazz();
        }
        ControlType type = ctrl.getControlType();
        if (type == null) {
            return ArcClazz.STIMULATION.getClazz();
        }
        switch (type) {
            case ACTIVATION: 
            case ACTIVATION_ALLOSTERIC: 
            case ACTIVATION_NONALLOSTERIC: 
            case ACTIVATION_UNKMECH: {
                return ArcClazz.STIMULATION.getClazz();
            }
            case INHIBITION: 
            case INHIBITION_ALLOSTERIC: 
            case INHIBITION_OTHER: 
            case INHIBITION_UNKMECH: 
            case INHIBITION_COMPETITIVE: 
            case INHIBITION_IRREVERSIBLE: 
            case INHIBITION_UNCOMPETITIVE: 
            case INHIBITION_NONCOMPETITIVE: {
                return ArcClazz.INHIBITION.getClazz();
            }
        }
        throw new RuntimeException("Invalid control type: " + type);
    }

    private static int getControllerSize(Set<Control> ctrlSet, java.util.Map<String, Glyph> glyphMap) {
        int size = 0;
        for (Control ctrl : ctrlSet) {
            size += L3ToSBGNPDConverter.getControllers(ctrl, glyphMap).size();
        }
        return size;
    }

    private static Set<PhysicalEntity> getControllers(Control ctrl, java.util.Map<String, Glyph> glyphMap) {
        HashSet<PhysicalEntity> controllers = new HashSet<PhysicalEntity>();
        for (Controller clr : ctrl.getController()) {
            if (!(clr instanceof PhysicalEntity) || !glyphMap.containsKey(clr.getRDFId())) continue;
            controllers.add((PhysicalEntity)clr);
        }
        return controllers;
    }

    private static void addPorts(Glyph g) {
        Port inputPort = factory.createPort();
        Port outputPort = factory.createPort();
        inputPort.setId(g.getId() + ".input");
        outputPort.setId(g.getId() + ".output");
        g.getPort().add(inputPort);
        g.getPort().add(outputPort);
    }

    private static void createArc(Object source, Object target, String clazz, java.util.Map<String, Arc> arcMap) {
        assert (source instanceof Glyph || source instanceof Port) : "source = " + source;
        assert (target instanceof Glyph || target instanceof Port) : "target = " + target;
        Arc arc = factory.createArc();
        arc.setSource(source);
        arc.setTarget(target);
        arc.setClazz(clazz);
        String sourceID = source instanceof Glyph ? ((Glyph)source).getId() : ((Port)source).getId();
        String targetID = target instanceof Glyph ? ((Glyph)target).getId() : ((Port)target).getId();
        arc.setId(sourceID + "--to--" + targetID);
        arcMap.put(arc.getId(), arc);
    }

    private static Set<Glyph> getRootGlyphs(Collection<Glyph> glyphCol) {
        HashSet<Glyph> root = new HashSet<Glyph>(glyphCol);
        HashSet<Glyph> children = new HashSet<Glyph>();
        for (Glyph glyph : glyphCol) {
            L3ToSBGNPDConverter.addChildren(glyph, children);
        }
        root.removeAll(children);
        return root;
    }

    private static void addChildren(Glyph glyph, Set<Glyph> set) {
        for (Glyph child : glyph.getGlyph()) {
            set.add(child);
            L3ToSBGNPDConverter.addChildren(child, set);
        }
    }

    static {
        factory = new ObjectFactory();
        typeMatchMap = new HashMap<Class<? extends BioPAXElement>, String>();
        typeMatchMap.put(Protein.class, "macromolecule");
        typeMatchMap.put(SmallMolecule.class, "simple chemical");
        typeMatchMap.put(Dna.class, "nucleic acid feature");
        typeMatchMap.put(Rna.class, "nucleic acid feature");
        typeMatchMap.put(DnaRegion.class, "nucleic acid feature");
        typeMatchMap.put(RnaRegion.class, "nucleic acid feature");
        typeMatchMap.put(NucleicAcid.class, "nucleic acid feature");
        typeMatchMap.put(PhysicalEntity.class, "unspecified entity");
        typeMatchMap.put(SimplePhysicalEntity.class, "unspecified entity");
        typeMatchMap.put(Complex.class, "complex");
    }
}

