/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sbgn;

import java.util.HashMap;
import java.util.List;
import org.biopax.paxtools.io.sbgn.VCompound;
import org.biopax.paxtools.io.sbgn.VNode;
import org.ivis.layout.LEdge;
import org.ivis.layout.LGraph;
import org.ivis.layout.LGraphManager;
import org.ivis.layout.LNode;
import org.ivis.layout.Layout;
import org.ivis.layout.cose.CoSELayout;
import org.sbgn.bindings.Arc;
import org.sbgn.bindings.Bbox;
import org.sbgn.bindings.Glyph;
import org.sbgn.bindings.Port;
import org.sbgn.bindings.Sbgn;

public class SBGNLayoutManager {
    private Layout layout;
    private VCompound root;
    private HashMap<VNode, LNode> viewToLayout;
    private HashMap<LNode, VNode> layoutToView;
    private HashMap<Glyph, VNode> glyphToVNode;
    private HashMap<String, Glyph> idToGLyph;

    public Sbgn createLayout(Sbgn sbgn) {
        this.viewToLayout = new HashMap();
        this.layoutToView = new HashMap();
        this.glyphToVNode = new HashMap();
        this.idToGLyph = new HashMap();
        this.layout = new CoSELayout();
        LGraphManager graphMan = this.layout.getGraphManager();
        LGraph lRoot = graphMan.addRoot();
        this.root = new VCompound();
        lRoot.vGraphObject = this.root;
        this.createVNodes(this.root, sbgn.getMap().getGlyph());
        for (VNode vNode : this.root.children) {
            this.createNode(vNode, null, this.layout);
        }
        this.createLedges(sbgn.getMap().getArc(), this.layout);
        graphMan.updateBounds();
        this.layout.runLayout();
        return sbgn;
    }

    public void createVNodes(VCompound parent, List<Glyph> glyphs) {
        for (Glyph glyph : glyphs) {
            if (glyph.getClazz() == "state variable" || glyph.getClazz() == "unit of information") continue;
            VCompound v = new VCompound();
            v.glyph = glyph;
            Bbox b = new Bbox();
            glyph.setBbox(b);
            v.setSizeAccordingToClass();
            this.idToGLyph.put(glyph.getId(), glyph);
            this.glyphToVNode.put(glyph, v);
            parent.children.add(v);
            this.createVNodes(v, glyph.getGlyph());
        }
    }

    public LNode getLNodeByPort(Port p) {
        String tmpStr = p.getId();
        if (tmpStr.lastIndexOf(".") > -1) {
            tmpStr = tmpStr.substring(0, tmpStr.lastIndexOf("."));
        }
        Glyph tmpG = this.idToGLyph.get(tmpStr);
        VNode tmpV = this.glyphToVNode.get(tmpG);
        return this.viewToLayout.get(tmpV);
    }

    public void createLedges(List<Arc> arcs, Layout layout) {
        for (Arc arc : arcs) {
            LNode targetLNode;
            LNode sourceLNode;
            LEdge lEdge = layout.newEdge(null);
            if (arc.getSource() instanceof Port) {
                sourceLNode = this.getLNodeByPort((Port)arc.getSource());
                arc.setSource((Object)this.layoutToView.get((Object)sourceLNode).glyph);
            } else {
                sourceLNode = this.viewToLayout.get(this.glyphToVNode.get(arc.getSource()));
            }
            if (arc.getTarget() instanceof Port) {
                targetLNode = this.getLNodeByPort((Port)arc.getTarget());
                arc.setTarget((Object)this.layoutToView.get((Object)targetLNode).glyph);
            } else {
                targetLNode = this.viewToLayout.get(this.glyphToVNode.get(arc.getTarget()));
            }
            this.layout.getGraphManager().add(lEdge, sourceLNode, targetLNode);
        }
    }

    public void createNode(VNode vNode, VNode parent, Layout layout) {
        LNode lNode = layout.newNode((Object)vNode);
        lNode.getRect().setWidth((double)vNode.glyph.getBbox().getW());
        lNode.getRect().setHeight((double)vNode.glyph.getBbox().getH());
        LGraph rootLGraph = layout.getGraphManager().getRoot();
        this.viewToLayout.put(vNode, lNode);
        this.layoutToView.put(lNode, vNode);
        if (parent != null) {
            LNode parentLNode = this.viewToLayout.get(parent);
            parentLNode.getChild().add(lNode);
        } else {
            rootLGraph.add(lNode);
        }
        if (vNode instanceof VCompound) {
            VCompound vCompound = (VCompound)vNode;
            layout.getGraphManager().add(layout.newGraph(null), lNode);
            for (VNode vNode2 : vCompound.getChildren()) {
                this.createNode(vNode2, vCompound, layout);
            }
            lNode.updateBounds();
        }
    }
}

