/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sbgn;

import java.util.ArrayList;
import org.ivis.layout.LGraphObject;
import org.ivis.layout.LNode;
import org.ivis.layout.Updatable;
import org.ivis.layout.cose.CoSEGraph;
import org.sbgn.bindings.Bbox;
import org.sbgn.bindings.Glyph;

public class VNode
implements Updatable {
    public Glyph glyph;
    public int clusterID;
    private static final String MACROMOLECULE = "macromolecule";
    private static final String UNIT_OF_INFORMATION = "unit of information";
    private static final String STATE_VARIABLE = "state variable";
    private static final String SOURCE_AND_SINK = "source and sink";
    private static final String ASSOCIATION = "association";
    private static final String DISSOCIATION = "dissociation";
    private static final String OMITTED_PROCESS = "omitted process";
    private static final String UNCERTAIN_PROCESS = "uncertain process";
    private static final String SIMPLE_CHEMICAL = "simple chemical";
    private static final String PROCESS = "process";
    private static final String COMPLEX = "complex";
    private static final String AND = "and";
    private static final String OR = "or";
    private static final String NOT = "not";
    private static final String PHENOTYPE = "phenotype";
    private static final String PERTURBING_AGENT = "perturbing agent";
    private static final String TAG = "tag";
    private static final String NUCLEIC_ACID_FEATURE = "nucleic acid feature";
    private static final String UNSPECIFIED_ENTITY = "unspecified entity";
    private Bound SOURCE_AND_SINK_BOUND = new Bound(60.0f, 60.0f);
    private Bound LOGICAL_OPERATOR_BOUND = new Bound(40.0f, 40.0f);
    private Bound PROCESS_NODES_BOUND = new Bound(20.0f, 20.0f);
    private Bound MACROMOLECULE_BOUND = new Bound(140.0f, 60.0f);
    private Bound NUCLEIC_ACID_FEATURE_BOUND = new Bound(140.0f, 60.0f);
    private Bound SIMPLE_CHEMICAL_BOUND = new Bound(60.0f, 60.0f);
    private Bound UNSPECIFIED_ENTITY_BOUND = new Bound(100.0f, 60.0f);
    private Bound PHENOTYPE_BOUND = new Bound(140.0f, 60.0f);
    private Bound PERTURBING_AGENT_BOUND;
    private Bound TAG_BOUND = new Bound(140.0f, 60.0f);
    private Bound INFO_BOUND;
    private Bound STATE_BOUND;

    public VNode() {
        this.PERTURBING_AGENT_BOUND = new Bound(140.0f, 60.0f);
        this.INFO_BOUND = new Bound(60.0f, 20.0f);
        this.STATE_BOUND = new Bound(180.0f, 30.0f);
    }

    public void update(LGraphObject lGraphObj) {
        if (lGraphObj instanceof CoSEGraph) {
            return;
        }
        LNode lNode = (LNode)lGraphObj;
        this.glyph.getBbox().setX((float)lNode.getRect().getX());
        this.glyph.getBbox().setY((float)lNode.getRect().getY());
        this.updateSizeForStateAndInfo();
    }

    public void setBounds(float w, float h) {
        this.glyph.getBbox().setW(w);
        this.glyph.getBbox().setH(h);
    }

    public void setSizeAccordingToClass() {
        String glyphClass = this.glyph.getClazz();
        if (glyphClass == SOURCE_AND_SINK) {
            this.setBounds(this.SOURCE_AND_SINK_BOUND.getWidth(), this.SOURCE_AND_SINK_BOUND.getHeight());
        } else if (glyphClass == AND || glyphClass == OR || glyphClass == NOT) {
            this.setBounds(this.LOGICAL_OPERATOR_BOUND.getWidth(), this.LOGICAL_OPERATOR_BOUND.getHeight());
        } else if (glyphClass == ASSOCIATION || glyphClass == DISSOCIATION || glyphClass == OMITTED_PROCESS || glyphClass == UNCERTAIN_PROCESS || glyphClass == PROCESS) {
            this.setBounds(this.PROCESS_NODES_BOUND.getWidth(), this.PROCESS_NODES_BOUND.getHeight());
        } else if (glyphClass == SIMPLE_CHEMICAL) {
            this.setBounds(this.SIMPLE_CHEMICAL_BOUND.getWidth(), this.SIMPLE_CHEMICAL_BOUND.getHeight());
        } else if (glyphClass == UNSPECIFIED_ENTITY) {
            this.setBounds(this.UNSPECIFIED_ENTITY_BOUND.getWidth(), this.UNSPECIFIED_ENTITY_BOUND.getHeight());
        } else if (glyphClass == MACROMOLECULE) {
            this.setBounds(this.MACROMOLECULE_BOUND.getWidth(), this.MACROMOLECULE_BOUND.getHeight());
        } else if (glyphClass == NUCLEIC_ACID_FEATURE) {
            this.setBounds(this.NUCLEIC_ACID_FEATURE_BOUND.getWidth(), this.NUCLEIC_ACID_FEATURE_BOUND.getHeight());
        } else if (glyphClass == STATE_VARIABLE) {
            this.setBounds(this.STATE_BOUND.getWidth(), this.STATE_BOUND.getHeight());
        } else if (glyphClass == UNIT_OF_INFORMATION) {
            this.setBounds(this.INFO_BOUND.getWidth(), this.INFO_BOUND.getHeight());
        } else if (glyphClass == PHENOTYPE) {
            this.setBounds(this.PHENOTYPE_BOUND.getWidth(), this.PHENOTYPE_BOUND.getHeight());
        } else if (glyphClass == PERTURBING_AGENT) {
            this.setBounds(this.PERTURBING_AGENT_BOUND.getWidth(), this.PERTURBING_AGENT_BOUND.getHeight());
        } else if (glyphClass == TAG) {
            this.setBounds(this.TAG_BOUND.getWidth(), this.TAG_BOUND.getHeight());
        } else {
            this.setBounds(0.0f, 0.0f);
        }
        if (glyphClass == MACROMOLECULE || glyphClass == NUCLEIC_ACID_FEATURE || glyphClass == SIMPLE_CHEMICAL || glyphClass == COMPLEX) {
            this.updateSizeForStateAndInfo();
        }
    }

    public void updateSizeForStateAndInfo() {
        Bbox b;
        Glyph tmpglyph;
        int i;
        int offset = 10;
        float parent_y_up = this.glyph.getBbox().getY() - this.INFO_BOUND.height / 2.0f;
        float parent_y_bot = this.glyph.getBbox().getY() + this.glyph.getBbox().getH() - this.STATE_BOUND.height / 2.0f;
        float parent_x_up = this.glyph.getBbox().getX();
        String parentID = this.glyph.getId();
        ArrayList<Glyph> stateGlyphs = new ArrayList<Glyph>();
        ArrayList<Glyph> infoGlyphs = new ArrayList<Glyph>();
        for (Glyph glyph : this.glyph.getGlyph()) {
            if (glyph.getClazz() == STATE_VARIABLE) {
                stateGlyphs.add(glyph);
                continue;
            }
            if (glyph.getClazz() != UNIT_OF_INFORMATION) continue;
            infoGlyphs.add(glyph);
        }
        int numOfStates = stateGlyphs.size();
        int numOfInfos = infoGlyphs.size();
        float requiredWidthForStates = (float)((numOfStates + 1) * offset) + (float)numOfStates * this.STATE_BOUND.width;
        float requiredWidthForInfos = (float)((numOfStates + 1) * offset) + (float)numOfStates * this.STATE_BOUND.width;
        if (this.glyph.getBbox().getW() < requiredWidthForInfos || this.glyph.getBbox().getW() < requiredWidthForInfos) {
            this.glyph.getBbox().setW(Math.max(requiredWidthForStates, requiredWidthForInfos));
        }
        for (i = 0; i < numOfStates; ++i) {
            tmpglyph = (Glyph)stateGlyphs.get(i);
            b = new Bbox();
            tmpglyph.setBbox(b);
            tmpglyph.setId(parentID + ".state." + (i + 1));
            tmpglyph.getBbox().setX(parent_x_up + (float)((i + 1) * offset) + (float)i * this.STATE_BOUND.getWidth());
            tmpglyph.getBbox().setY(parent_y_bot);
            tmpglyph.getBbox().setW(this.STATE_BOUND.width);
            tmpglyph.getBbox().setH(this.STATE_BOUND.height);
        }
        for (i = 0; i < numOfInfos; ++i) {
            tmpglyph = (Glyph)infoGlyphs.get(i);
            b = new Bbox();
            tmpglyph.setBbox(b);
            tmpglyph.setId(parentID + ".info." + (i + 1));
            tmpglyph.getBbox().setX(parent_x_up + (float)((i + 1) * offset) + (float)i * this.INFO_BOUND.getWidth());
            tmpglyph.getBbox().setY(parent_y_up);
            tmpglyph.getBbox().setW(this.INFO_BOUND.width);
            tmpglyph.getBbox().setH(this.INFO_BOUND.height);
        }
    }

    public class Bound {
        public float width;
        public float height;

        public Bound(float width, float height) {
            this.width = width;
            this.height = height;
        }

        public float getWidth() {
            return this.width;
        }

        public void setWidth(float width) {
            this.width = width;
        }

        public float getHeight() {
            return this.height;
        }

        public void setHeight(float height) {
            this.height = height;
        }
    }
}

