/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sif;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.io.sif.BinaryInteractionType;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level2.XReferrable;
import org.biopax.paxtools.model.level2.complex;
import org.biopax.paxtools.model.level2.entity;
import org.biopax.paxtools.model.level2.physicalEntity;
import org.biopax.paxtools.model.level2.physicalEntityParticipant;
import org.biopax.paxtools.model.level2.xref;

public class SimpleInteraction {
    private BioPAXElement source;
    private BioPAXElement target;
    private BinaryInteractionType type;
    Log log = LogFactory.getLog(SimpleInteraction.class);
    private Set<BioPAXElement> mediators;

    public SimpleInteraction(BioPAXElement source, BioPAXElement target, BinaryInteractionType type) {
        this.source = source;
        this.target = target;
        this.type = type;
        this.mediators = new HashSet<BioPAXElement>();
    }

    public SimpleInteraction(BioPAXElement source, BioPAXElement target, BinaryInteractionType type, BioPAXElement ... mediator) {
        this(source, target, type, Arrays.asList(mediator));
    }

    public SimpleInteraction(BioPAXElement source, BioPAXElement target, BinaryInteractionType type, Collection<BioPAXElement> mediator) {
        this(source, target, type);
        this.mediators.addAll(mediator);
    }

    public BioPAXElement getSource() {
        return this.source;
    }

    public void setSource(BioPAXElement source) {
        this.source = source;
    }

    public BioPAXElement getTarget() {
        return this.target;
    }

    public void setTarget(BioPAXElement target) {
        this.target = target;
    }

    public BinaryInteractionType getType() {
        return this.type;
    }

    public void setType(BinaryInteractionType type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleInteraction that = (SimpleInteraction)o;
        return this.checkNullOrEquals((Object)this.type, (Object)that.type) && this.checkParticipants(that);
    }

    private boolean checkParticipants(SimpleInteraction that) {
        boolean equal;
        boolean bl = equal = this.checkNullOrEquals(this.source, that.source) && this.checkNullOrEquals(this.target, that.target);
        if (!(equal || this.type != null && this.type.isDirected())) {
            equal = this.checkNullOrEquals(this.source, that.target) && this.checkNullOrEquals(this.target, that.source);
        }
        return equal;
    }

    private boolean checkNullOrEquals(Object thisObject, Object thatObject) {
        return thisObject == null ? thatObject == null : thisObject.equals(thatObject);
    }

    public int hashCode() {
        return (this.type.hashCode() + (this.type.isDirected() ? 2 : 1) * this.source.hashCode() + this.target.hashCode()) / 17;
    }

    public String toString() {
        String from = this.source.getRDFId();
        String to = this.target == null ? "null" : this.target.getRDFId();
        return from + "\t" + this.type.toString() + "\t" + to;
    }

    public String getANameForSIF(BioPAXElement element) {
        String symbol;
        if (element instanceof XReferrable && (symbol = this.getRelatedEntrezGeneID((XReferrable)element)) != null) {
            return symbol;
        }
        if (element instanceof entity) {
            String synonym;
            entity ent = (entity)element;
            if (ent.getSHORT_NAME() != null && ent.getSHORT_NAME().length() > 0) {
                return ent.getSHORT_NAME();
            }
            if (ent.getNAME() != null && ent.getNAME().length() > 0) {
                return ent.getNAME();
            }
            if (ent.getSYNONYMS() != null && !ent.getSYNONYMS().isEmpty() && (synonym = (String)ent.getSYNONYMS().iterator().next()) != null && synonym.length() > 0) {
                return synonym;
            }
        }
        return element.getRDFId();
    }

    public String getRelatedEntrezGeneID(XReferrable obj) {
        for (xref xr : obj.getXREF()) {
            if (xr.getDB() == null || !xr.getDB().equalsIgnoreCase("GENE_SYMBOL") || xr.getID() == null) continue;
            return xr.getID();
        }
        return null;
    }

    public void reduceComplexes(Set<SimpleInteraction> reducedInts) {
        if (this.getType() != BinaryInteractionType.COMPONENT_OF) {
            HashSet<physicalEntity> sourceSet = new HashSet<physicalEntity>();
            HashSet<physicalEntity> targetSet = new HashSet<physicalEntity>();
            this.recursivelyReduce(this.getSource(), sourceSet);
            this.recursivelyReduce(this.getTarget(), targetSet);
            for (physicalEntity source : sourceSet) {
                for (physicalEntity target : targetSet) {
                    SimpleInteraction interaction2 = new SimpleInteraction((BioPAXElement)source, (BioPAXElement)target, this.type);
                    interaction2.getMediators().addAll(this.getMediators());
                    reducedInts.add(interaction2);
                }
            }
        }
    }

    private void recursivelyReduce(BioPAXElement bpe, Set<physicalEntity> reduced) {
        if (bpe instanceof physicalEntityParticipant) {
            this.recursivelyReduce((BioPAXElement)((physicalEntityParticipant)bpe).getPHYSICAL_ENTITY(), reduced);
        } else if (bpe instanceof complex) {
            for (physicalEntityParticipant pep : ((complex)bpe).getCOMPONENTS()) {
                physicalEntity pe = pep.getPHYSICAL_ENTITY();
                this.recursivelyReduce((BioPAXElement)pe, reduced);
            }
        } else if (bpe instanceof physicalEntity) {
            reduced.add((physicalEntity)bpe);
        }
    }

    public Set<BioPAXElement> getMediators() {
        return this.mediators;
    }

    public void addMediator(BioPAXElement element) {
        this.mediators.add(element);
    }
}

