/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sif.level3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.biopax.paxtools.io.sif.BinaryInteractionType;
import org.biopax.paxtools.io.sif.level3.Group;
import org.biopax.paxtools.io.sif.level3.InteractionRuleL3Adaptor;
import org.biopax.paxtools.io.sif.level3.InteractionSetL3;
import org.biopax.paxtools.io.sif.level3.PEStateChange;
import org.biopax.paxtools.io.sif.level3.Simplify;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.Model;
import org.biopax.paxtools.model.level3.Control;
import org.biopax.paxtools.model.level3.Conversion;
import org.biopax.paxtools.model.level3.Interaction;
import org.biopax.paxtools.model.level3.PhysicalEntity;
import org.biopax.paxtools.model.level3.Process;

public class ControlRule
extends InteractionRuleL3Adaptor {
    private final Log log = LogFactory.getLog(ControlRule.class);
    private static List<BinaryInteractionType> binaryInteractionTypes = Arrays.asList(BinaryInteractionType.METABOLIC_CATALYSIS, BinaryInteractionType.STATE_CHANGE);
    private boolean mineStateChange;
    private boolean storeStateChange;
    private boolean mineMetabolicChange;
    public static final String STORE_STATE_CHANGE = "StoreStateChange";
    private HashMap<BioPAXElement, Set<PEStateChange>> stateChanges;

    public HashMap<BioPAXElement, Set<PEStateChange>> getStateChanges() {
        return this.stateChanges;
    }

    @Override
    public void initOptionsNotNull(Map options) {
        this.mineStateChange = !this.checkOption((Object)BinaryInteractionType.STATE_CHANGE, Boolean.FALSE, options);
        this.mineMetabolicChange = !this.checkOption((Object)BinaryInteractionType.METABOLIC_CATALYSIS, Boolean.FALSE, options);
        this.storeStateChange = this.checkOption(STORE_STATE_CHANGE, Boolean.TRUE, options);
        if (this.storeStateChange) {
            this.stateChanges = new HashMap();
        }
    }

    @Override
    public void inferInteractionsFromPE(InteractionSetL3 is3, PhysicalEntity pe, Model model) {
        BioPAXElement source = is3.getGroupMap().getEntityReferenceOrGroup((BioPAXElement)pe);
        for (Interaction inter : pe.getParticipantOf()) {
            if (!(inter instanceof Control)) continue;
            Control cont = (Control)inter;
            for (Conversion conv : this.getAffectedConversions(cont, null)) {
                this.processConversion(is3, source, cont, conv);
            }
        }
    }

    private void processConversion(InteractionSetL3 is3, BioPAXElement source, Control cont, Conversion conv) {
        Set<BioPAXElement> left = this.collectEntities(conv.getLeft(), is3);
        Set<BioPAXElement> right = this.collectEntities(conv.getRight(), is3);
        HashSet<BioPAXElement> intersection = new HashSet<BioPAXElement>(left);
        intersection.retainAll(right);
        HashSet<BioPAXElement> union = new HashSet<BioPAXElement>(left);
        union.addAll(right);
        for (BioPAXElement target : union) {
            if (source == target || target instanceof Group && ((Group)target).getType() == BinaryInteractionType.COMPONENT_OF) continue;
            this.mineTarget(source, target, is3, cont, conv, intersection);
        }
    }

    private void mineTarget(BioPAXElement source, BioPAXElement target, InteractionSetL3 is3, Control cont, Conversion conv, Set<BioPAXElement> intersection) {
        if (Simplify.entityHasAChange(target, conv, is3.getGroupMap(), this.stateChanges)) {
            if (intersection.contains(target)) {
                if (this.mineStateChange) {
                    this.createAndAdd(source, target, is3, BinaryInteractionType.STATE_CHANGE, new BioPAXElement[]{cont, conv});
                }
            } else if (this.mineMetabolicChange) {
                this.createAndAdd(source, target, is3, BinaryInteractionType.METABOLIC_CATALYSIS, new BioPAXElement[]{cont, conv});
            }
        }
    }

    private List<Conversion> getAffectedConversions(Control cont, List<Conversion> convList) {
        if (convList == null) {
            convList = new ArrayList<Conversion>();
        }
        for (Process prcss : cont.getControlled()) {
            if (prcss instanceof Conversion) {
                convList.add((Conversion)prcss);
                continue;
            }
            if (!(prcss instanceof Control)) continue;
            this.getAffectedConversions((Control)prcss, convList);
        }
        return convList;
    }

    @Override
    public List<BinaryInteractionType> getRuleTypes() {
        return binaryInteractionTypes;
    }
}

