/*
 * Decompiled with CFR 0.152.
 */
package org.biopax.paxtools.io.sif.level3;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.biopax.paxtools.impl.level3.EntityReferenceImpl;
import org.biopax.paxtools.io.sif.BinaryInteractionType;
import org.biopax.paxtools.model.BioPAXElement;
import org.biopax.paxtools.model.level3.EntityReference;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Cache(usage=CacheConcurrencyStrategy.NONE)
public class Group
extends EntityReferenceImpl {
    Set<EntityReference> members = new HashSet<EntityReference>();
    Set<Group> subgroups = new HashSet<Group>();
    BinaryInteractionType type;
    Class<? extends BioPAXElement> genericType;
    Set<BioPAXElement> sources;

    Group(BinaryInteractionType type, BioPAXElement source) {
        this.type = type;
        this.sources = new HashSet<BioPAXElement>();
        this.sources.add(source);
    }

    public String getRDFId() {
        return "http://biopax.org/generated/group/" + this.hashCode();
    }

    public boolean isEquivalent(BioPAXElement element) {
        return this.equals(element);
    }

    public int equivalenceCode() {
        return this.hashCode();
    }

    public void addMember(EntityReference member) {
        this.members.add(member);
    }

    public void addSubgroup(Group subgroup) {
        if (subgroup == this) {
            throw new IllegalArgumentException();
        }
        this.subgroups.add(subgroup);
    }

    public BinaryInteractionType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && o instanceof Group) {
            Group that = (Group)((Object)o);
            if (this.isEmpty()) {
                return ((Object)this.sources).equals(that.sources);
            }
            return this.type.equals((Object)that.type) && ((Object)this.members).equals(that.members) && ((Object)this.subgroups).equals(that.subgroups);
        }
        return false;
    }

    public int hashCode() {
        int code = this.isEmpty() ? (this.sources.isEmpty() ? super.hashCode() : ((Object)this.sources).hashCode()) : ((Object)this.members).hashCode() / 17 + ((Object)this.subgroups).hashCode() / 23 + this.getType().hashCode();
        return code;
    }

    public boolean isEmpty() {
        return this.members.isEmpty() && this.subgroups.isEmpty();
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder();
        bldr.append((Object)this.type).append("{");
        if (!this.isEmpty()) {
            for (EntityReference member : this.members) {
                bldr.append(member.getRDFId()).append(",");
            }
            for (Group subgroup : this.subgroups) {
                bldr.append(subgroup.toString()).append(",");
            }
            bldr.deleteCharAt(bldr.length() - 1);
        }
        return bldr.append("}").toString();
    }

    public Map<String, Object> getAnnotations() {
        throw new UnsupportedOperationException("getAnnotations() is not supported for this (special) BioPAXElement: " + ((Object)((Object)this)).getClass());
    }

    public String groupTypeToString() {
        if (this.type == BinaryInteractionType.COMPONENT_OF) {
            return "ComplexGroup";
        }
        if (this.type == BinaryInteractionType.GENERIC_OF) {
            return "Generic" + (this.genericType == null ? "" : this.genericType.getSimpleName());
        }
        throw new IllegalStateException();
    }
}

